/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/
#ifndef MDICCONV_H
#define MDICCONV_H

#include <QDialog>
#include <QTimer>

#include "ui_mdicconvform.h"

class QProcess;
class MDicConv: public QDialog, public Ui::MDicConvForm
{
    Q_OBJECT
public:
    MDicConv(QWidget *parent = 0);

protected slots:
    void sltBrowseMDicConv();
    void sltBrowseFile();
    void sltBrowseDestDir();
    void sltCheckPath(const QString&);
    void sltConvert();
    void sltAddDb();
    void sltTimer();
    void sltProcessExited(int);
    void sltLog(bool);
    void sltDirChanged(bool);

private:
    int counter;
    bool isPathOK;
    QString destFileName;
    QString destFile;
    QProcess *p;
    QTimer pTimer;
    bool success;
};

#endif
