/*
   This file is part of MDic Dictionary
   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#include "generalconfig.h"
#include "settings.h"
#include "ui_generalconfigbase.h"
#include <aspell.h>

class GeneralConfigWidget::Private
{
public:
    Ui_GeneralConfigBase ui;
};
GeneralConfigWidget::GeneralConfigWidget(QWidget* parent, Qt::WindowFlags f)
        : QWidget(parent, f), d(new Private)
{
    d->ui.setupUi(this);
    loadSpellCheckerDictionaries();
    load();
}

GeneralConfigWidget::~GeneralConfigWidget()
{
    delete d;
}

void GeneralConfigWidget::load()
{
    d->ui.chkShowOnStart->setChecked(Settings::self()->showOnStart);
    d->ui.chkAlwaysSearchRemote->setChecked(Settings::self()->alwaysSearchRemoteResources);

    d->ui.chkClipboard->setChecked(Settings::self()->clipboardWatcher);
    d->ui.chkSpeakAny->setChecked(Settings::self()->speakAny);
    d->ui.chkSpeech->setChecked(Settings::self()->speech);
    d->ui.chkModifier->setChecked(Settings::self()->modStatus);
    d->ui.comboModifier->setCurrentIndex(Settings::self()->mod);
    d->ui.triggerMaxChar->setValue(Settings::self()->triggerMaxChar);

    d->ui.chkSpellChecking->setChecked(Settings::self()->isSpellingEnabled);
    int index = d->ui.comboSpellDictsList->findData(Settings::self()->spellingLang);
    d->ui.comboSpellDictsList->setCurrentIndex(index);

    d->ui.spnHistorylen->setValue(Settings::self()->histLen);
}

void GeneralConfigWidget::save()
{
    Settings::self()->showOnStart = d->ui.chkShowOnStart->isChecked();
    Settings::self()->alwaysSearchRemoteResources = d->ui.chkAlwaysSearchRemote->isChecked();

    Settings::self()->clipboardWatcher = d->ui.chkClipboard->isChecked();
    Settings::self()->speakAny = d->ui.chkSpeakAny->isChecked();
    Settings::self()->speech = d->ui.chkSpeech->isChecked();
    Settings::self()->modStatus = d->ui.chkModifier->isChecked();
    Settings::self()->mod = d->ui.comboModifier->currentIndex();
    Settings::self()->triggerMaxChar = d->ui.triggerMaxChar->value();

    Settings::self()->isSpellingEnabled = d->ui.chkSpellChecking->isChecked();
    int index = d->ui.comboSpellDictsList->currentIndex();
    Settings::self()->spellingLang = d->ui.comboSpellDictsList->itemData(index).toString();

    Settings::self()->histLen = d->ui.spnHistorylen->value();
}

void GeneralConfigWidget::loadSpellCheckerDictionaries()
{
    AspellConfig * config;
    AspellDictInfoList * dlist;
    AspellDictInfoEnumeration * dels;
    const AspellDictInfo * entry;

    config = new_aspell_config();

    /* the returned pointer should _not_ need to be deleted */
    dlist = get_aspell_dict_info_list(config);

    /* config is no longer needed */
    delete_aspell_config(config);

    dels = aspell_dict_info_list_elements(dlist);

    d->ui.comboSpellDictsList->clear();
    while ((entry = aspell_dict_info_enumeration_next(dels)) != 0) {
        d->ui.comboSpellDictsList->addItem(QString(entry->name), QString(entry->code));
    }

    delete_aspell_dict_info_enumeration(dels);
}

#include "generalconfig.moc"
