/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#ifndef DICTIONARYCONFIG_H
#define DICTIONARYCONFIG_H
#include <QWidget>
#include <dictcore.h>

class QTableWidgetItem;
class DictionaryConfigWidget : public QWidget
{
    Q_OBJECT
public:
    explicit DictionaryConfigWidget(QWidget* parent = 0, Qt::WindowFlags f = 0);
    ~DictionaryConfigWidget();
    void save();
    void load();

protected slots:
    void addDictionary();
    void removeCurrentDictionary();
    void showConvertDialog();
    void showDictionaryProperties();

    void moveRowUp();
    void moveRowDown();

private:
    void move(bool up);
    QList<QTableWidgetItem*> takeRow(int row);
    void setRow(int row, const QList<QTableWidgetItem*>& rowItems);
    void loadDb(const DictCore::Dictionary &dic);
    class Private;
    Private *d;
};

#endif // DICTIONARYCONFIG_H
