/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "dbproperties.h"

DBProperties::DBProperties(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
}

void DBProperties::showForm(const DictInfo &dict)
{
    txtDbName->setText(dict.name());
    lblDesc->setHtml(dict.description());
    lblAuthor->setText(dict.author());
    lblCount->setText( QString::number(dict.wordsCount()) );
    lblLicense->setText(dict.license());
    lblDest->setText(dict.destinationLanguage());
    lblSrc->setText(dict.sourceLanguage());
    this->show();
}

#include "dbproperties.moc"
