<?xml version="1.0" encoding="ISO-8859-1"?>

<!-- Stylesheet to convert JavaHelp index and TOC pages into HTML -->

<!-- This file is part of JMRI.  Copyright 2007, 2015.                            -->
<!--                                                                        -->
<!-- JMRI is free software; you can redistribute it and/or modify it under  -->
<!-- the terms of version 2 of the GNU General Public License as published  -->
<!-- by the Free Software Foundation. See the "COPYING" file for a copy     -->
<!-- of this license.                                                       -->
<!--                                                                        -->
<!-- JMRI is distributed in the hope that it will be useful, but WITHOUT    -->
<!-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or  -->
<!-- FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  -->
<!-- for more details.                                                      -->

<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Need to instruct the XSLT processor to use HTML output rules.
     See http://www.w3.org/TR/xslt#output for more details
-->
<xsl:output method="html" encoding="UTF-8"/>

<!-- This first template matches our root element in the input file.
     This will trigger the generation of the header.
     In between we let the processor recursively process any contained
     elements, which is what the apply-templates instruction does.
     We also pick some stuff out explicitly in the head section using
     value-of instructions.
-->
<xsl:template match='toc'>
<xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;&#xA;</xsl:text>
<html lang="fr">
<head>
    <title>JMRI Help System: JMRI Local TOC</title>
    <meta name="author" content="Dave Sand" />
    <meta name="keywords" content="JMRI Help Index" />

    <xsl:comment>=====================================================================</xsl:comment>
    <xsl:comment>This file is automatically generated by Ant from JmriHelp_frTOC.xml</xsl:comment>
    <xsl:comment>Do not edit it directly</xsl:comment>
    <xsl:comment>=====================================================================</xsl:comment>

    <script>

        var use_internet = false;

        function openLink(link) {

            if (link.includes("/manual/")) {
                if (!use_internet) {
                    if (window.confirm("Manual help pages are not installed.\nIf internet is available, use jmri.org?")) {
                        use_internet = true;
                    }
                }
                if (use_internet) {
                    link = "https://jmri.org/help/en/manual/" + link;
                } else {
                    return;
                }
            }

            document.getElementById("page").src = link;
        }

        function onLoad() {
            var url = window.location.href;
            var i = url.indexOf('#');
            var urlParts = [url.slice(0,i), url.slice(i+1)];
            if (urlParts[1] != "") {
                var link = urlParts[1].replace(/\./g, '/')

                // find fragment
                var frag = '';
                var j = link.indexOf('_');
                if (j > 0) {
                    var fragParts = [link.slice(0,j), link.slice(j+1)];
                    link = fragParts[0];
                    frag = '#' + fragParts[1];
                }

                var newURL = '../' + link + '.shtml' + frag;
                openLink(newURL);
            } else {
                openLink('../index.shtml');
            }
        }
    </script>

    <style>
        h2 {
            text-align: center;
        }

        a {
            text-decoration: underline;
            cursor: pointer;
        }

        .float-container {
            border: 3px solid #fff;
            padding: 20px;
        }

        .float-child-index {
            width: 30%;
            float: left;
            padding: 20px;
            border: 2px solid black;
            height: 600px;
            overflow: auto;
        }

        .float-child-page {
            width: 60%;
            float: left;
            padding: 20px;
            border: 2px solid black;
        }

        .clear {
            clear: both;
        }
    </style>
</head>

<body onload="onLoad()">
    <div class="float-container">
        <div class="float-child-index">
            <ul>
                <xsl:apply-templates/>
            </ul>
        </div>
    <iframe class="float-child-page" id="page" height="600" src="../index.shtml" title="JMRI Help"></iframe>
    </div>
    <xsl:text disable-output-escaping='yes'>&lt;p class="clear"&gt; &#x26;nbsp; &lt;/p&gt; &#xA;</xsl:text>
</body>
</html>
</xsl:template>

<!-- recursively handle toc items -->
<!-- if there's a target, convert to a iframe link -->
<xsl:template match="tocitem">
    <li>
        <xsl:if test="@target">
            <xsl:element name="a">
                <xsl:attribute name="id">
                    <xsl:value-of select="@target" />
                </xsl:attribute>
            </xsl:element>
            <xsl:element name="a">
                <xsl:attribute name="onclick">
                    <xsl:variable name="target" select="@target" />
                    <xsl:for-each select="document('local/jmri_map.xml')/map/mapID">
                      <xsl:if test="( @target = $target )" >
                        openLink('../<xsl:value-of select="@url"/>')
                      </xsl:if>
                    </xsl:for-each>
                </xsl:attribute>
                <xsl:value-of select="@text"/>
            </xsl:element>
	    </xsl:if>
        <xsl:if test="not(@target)" >
                <xsl:value-of select="@text"/>
	    </xsl:if>

        <ul>
        <xsl:apply-templates/>
        </ul>
    </li>
</xsl:template>


</xsl:stylesheet>
