/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing.border;

import com.alexandriasoftware.swing.Validation;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.annotation.Nonnull;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ValidatorBorder
extends CompoundBorder {
    private static final long serialVersionUID = 1L;
    private final Validation validation;
    private Font font;

    public ValidatorBorder(final @Nonnull Validation validation, Border originalBorder) {
        this.validation = validation;
        this.font = this.validation.getFont().deriveFont(1, 0.0f);
        this.outsideBorder = originalBorder;
        this.insideBorder = new AbstractBorder(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintBorder(Component c, @Nonnull Graphics g, int x, int y, int width, int height) {
                Insets insets = ValidatorBorder.this.outsideBorder.getBorderInsets(c);
                FontMetrics metrics = ValidatorBorder.this.getFontMetrics(c);
                int by = c.getHeight() / 2 + metrics.getAscent() / 2 - insets.top;
                int bw = Math.max(2, insets.right);
                int iw = metrics.stringWidth(validation.getIcon());
                int bx = x + width - Math.round((float)iw * 1.5f + (float)bw * 1.5f) + 2;
                g.translate(bx, by);
                g.setColor(validation.getColor());
                g.setFont(ValidatorBorder.this.font);
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                }
                g.drawString(validation.getIcon(), x + iw / 2, y);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                FontMetrics metrics = ValidatorBorder.this.getFontMetrics(c);
                int iw = metrics.stringWidth(validation.getIcon());
                insets.right = Math.round((float)iw * 1.5f);
                return insets;
            }
        };
    }

    private FontMetrics getFontMetrics(Component c) {
        Font cFont = c.getFont();
        if (this.font.getSize() != cFont.getSize()) {
            this.font = this.validation.getFont().deriveFont(1, cFont.getSize());
        }
        return c.getFontMetrics(this.font);
    }
}

