/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing;

import com.alexandriasoftware.swing.Validation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.SystemColor;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import org.slf4j.LoggerFactory;

public class JInputValidatorPreferences {
    private static JInputValidatorPreferences defaultPreferences = null;
    private final Font font;
    private final String unknownIcon;
    private final Color unknownColor;
    private final String informationIcon;
    private final Color informationColor;
    private final String successIcon;
    private final Color successColor;
    private final String warningIcon;
    private final Color warningColor;
    private final String dangerIcon;
    private final Color dangerColor;

    public static synchronized JInputValidatorPreferences getPreferences() {
        if (defaultPreferences == null) {
            defaultPreferences = new JInputValidatorPreferences();
        }
        return defaultPreferences;
    }

    public static JInputValidatorPreferences getPreferences(Preferences preferences) {
        return new JInputValidatorPreferences(preferences);
    }

    private JInputValidatorPreferences() {
        this(Preferences.userNodeForPackage(JInputValidatorPreferences.class));
    }

    private JInputValidatorPreferences(Preferences preferences) {
        Font f;
        Preferences defaults = Preferences.userNodeForPackage(JInputValidatorPreferences.class);
        String fontAwesome = "/com/fontawesome/Font Awesome 5 Free-Solid-900.otf";
        try {
            f = Font.createFont(0, JInputValidatorPreferences.class.getResourceAsStream(preferences.get("font", defaults.get("font", fontAwesome))));
        }
        catch (FontFormatException | IOException ex) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to get Font resource named {}", (Object)preferences.get("font", fontAwesome), (Object)ex);
            f = new JLabel().getFont();
        }
        this.font = f;
        this.unknownIcon = preferences.get("unknown.icon", defaults.get("unknown.icon", "\uf059"));
        this.unknownColor = new Color(preferences.getInt("unknown.color", defaults.getInt("inknown.color", 7585015)));
        this.informationIcon = preferences.get("information.icon", defaults.get("information.icon", "\uf05a"));
        this.informationColor = new Color(preferences.getInt("information.color", defaults.getInt("information.color", 7585015)));
        this.successIcon = preferences.get("success.icon", defaults.get("success.icon", "\uf058"));
        this.successColor = new Color(preferences.getInt("success.color", defaults.getInt("success.color", 9622528)));
        this.warningIcon = preferences.get("warning.icon", defaults.get("warning.icon", "\uf071"));
        this.warningColor = new Color(preferences.getInt("warning.color", defaults.getInt("warning.color", 15772416)));
        this.dangerIcon = preferences.get("danger.icon", defaults.get("danger.icon", "\uf06a"));
        this.dangerColor = new Color(preferences.getInt("danger.color", defaults.getInt("danger.color", 13179147)));
    }

    public Font getFont() {
        return this.font;
    }

    public String getIcon(Validation.Type type) {
        switch (type) {
            case UNKNOWN: {
                return this.unknownIcon;
            }
            case INFORMATION: {
                return this.informationIcon;
            }
            case SUCCESS: {
                return this.successIcon;
            }
            case WARNING: {
                return this.warningIcon;
            }
            case DANGER: {
                return this.dangerIcon;
            }
        }
        return "";
    }

    public Color getColor(Validation.Type type) {
        switch (type) {
            case UNKNOWN: {
                return this.unknownColor;
            }
            case INFORMATION: {
                return this.informationColor;
            }
            case SUCCESS: {
                return this.successColor;
            }
            case WARNING: {
                return this.warningColor;
            }
            case DANGER: {
                return this.dangerColor;
            }
        }
        return SystemColor.textText;
    }
}

