/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing.networktree;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openlcb.Connection;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.VerifyNodeIDNumberMessage;
import org.openlcb.swing.networktree.NodeTreeRep;

public class TreePane
extends JPanel {
    private static final long serialVersionUID = -5584629209112478729L;
    MimicNodeStore store;
    DefaultMutableTreeNode nodes;
    DefaultTreeModel treeModel;
    JTree tree;
    SortOrder sortOrder = SortOrder.BY_NODE_ID;
    NodeID nullNode = new NodeID(new byte[]{0, 0, 0, 0, 0, 0});
    private Timer timer;
    private boolean needResortTree = false;
    PropertyChangeListener resortListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("updateSimpleNodeIdent")) {
                Timer timer = TreePane.this.timer;
                synchronized (timer) {
                    TreePane.this.needResortTree = true;
                }
                TreePane.this.timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Timer timer = TreePane.this.timer;
                        synchronized (timer) {
                            if (TreePane.this.needResortTree) {
                                SwingUtilities.invokeLater(() -> TreePane.this.resortTree());
                                TreePane.this.needResortTree = false;
                            }
                        }
                    }
                }, 100L);
            }
        }
    };

    MimicNodeStore getStore() {
        return this.store;
    }

    DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public TreePane() {
        this.timer = new Timer("OpenLCB Tree Pane Timer");
    }

    public void initComponents(final MimicNodeStore store, final Connection connection, final NodeID node, final NodeTreeRep.SelectionKeyLoader loader) {
        this.store = store;
        this.setPreferredSize(new Dimension(500, 700));
        this.nodes = new DefaultMutableTreeNode("OpenLCB Network");
        this.setLayout(new BoxLayout(this, 1));
        this.treeModel = new DefaultTreeModel(this.nodes);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.setToolTipText("Reloads network view including the status of all nodes.");
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                store.refresh();
            }
        });
        bottomPanel.add(btnRefresh);
        final JButton btnSetSort = new JButton("Sort by...");
        btnSetSort.setToolTipText("Changes the sort order of the nodes.");
        btnSetSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu sortMenu = new JPopupMenu();
                sortMenu.add(TreePane.this.createSortMenuEntry("Node ID", SortOrder.BY_NODE_ID));
                sortMenu.add(TreePane.this.createSortMenuEntry("Name", SortOrder.BY_NAME));
                sortMenu.add(TreePane.this.createSortMenuEntry("Description", SortOrder.BY_DESCRIPTION));
                sortMenu.add(TreePane.this.createSortMenuEntry("Mfg/Model", SortOrder.BY_MODEL));
                sortMenu.show(btnSetSort, 0, btnSetSort.getHeight());
            }
        });
        bottomPanel.add(btnSetSort);
        bottomPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)bottomPanel.getPreferredSize().getHeight()));
        this.add(bottomPanel);
        store.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("AddNode")) {
                    MimicNodeStore.NodeMemo memo = (MimicNodeStore.NodeMemo)e.getNewValue();
                    if (!memo.getNodeID().equals(TreePane.this.nullNode)) {
                        NodeTreeRep n = new NodeTreeRep(memo, TreePane.this.getStore(), TreePane.this.getTreeModel(), loader);
                        TreePane.this.addNewHardwareNode(n);
                        n.initConnections();
                        memo.addPropertyChangeListener(TreePane.this.resortListener);
                    }
                } else if (e.getPropertyName().equals("ClearAllNodes")) {
                    DefaultMutableTreeNode defaultMutableTreeNode = TreePane.this.nodes;
                    synchronized (defaultMutableTreeNode) {
                        TreePane.this.nodes.removeAllChildren();
                        TreePane.this.treeModel.nodeStructureChanged(TreePane.this.nodes);
                        SwingUtilities.invokeLater(() -> TreePane.this.tree.expandPath(new TreePath(TreePane.this.nodes.getPath())));
                    }
                }
            }
        });
        for (MimicNodeStore.NodeMemo memo : store.getNodeMemos()) {
            if (memo.getNodeID().equals(this.nullNode)) continue;
            NodeTreeRep n = new NodeTreeRep(memo, store, this.treeModel, loader);
            this.addNewHardwareNode(n);
            n.initConnections();
        }
        this.tree.expandPath(new TreePath(this.nodes.getPath()));
        Connection.ConnectionListener cl = new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                connection.put(new VerifyNodeIDNumberMessage(node), null);
            }
        };
        if (connection != null) {
            connection.registerStartNotification(cl);
        }
        SwingUtilities.invokeLater(() -> {
            Window win = SwingUtilities.getWindowAncestor(this);
            if (win == null) {
                System.out.println("Could not add close window listener");
                return;
            }
            win.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    TreePane.this.release();
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                }

                @Override
                public void windowIconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowDeiconified(WindowEvent windowEvent) {
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                }

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                }
            });
        });
    }

    private JMenuItem createSortMenuEntry(String text, final SortOrder order) {
        AbstractAction action = new AbstractAction(text){
            private static final long serialVersionUID = -5448869191407809481L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePane.this.setSortOrder(order);
            }
        };
        JCheckBoxMenuItem it = new JCheckBoxMenuItem(action);
        it.setState(order == this.sortOrder);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewHardwareNode(NodeTreeRep n) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.nodes;
        synchronized (defaultMutableTreeNode) {
            int i;
            Comparator<NodeTreeRep> s = this.getSorter();
            for (i = 0; i < this.nodes.getChildCount() && s.compare((NodeTreeRep)this.nodes.getChildAt(i), n) < 0; ++i) {
            }
            this.treeModel.insertNodeInto(n, this.nodes, i);
        }
    }

    public void setSortOrder(SortOrder order) {
        if (this.sortOrder == order) {
            return;
        }
        this.sortOrder = order;
        SwingUtilities.invokeLater(() -> this.resortTree());
    }

    public void addTreeSelectionListener(final TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                listener.valueChanged(treeSelectionEvent);
                TreePane.this.tree.getSelectionModel().clearSelection();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.nodes;
        synchronized (defaultMutableTreeNode) {
            ArrayList<NodeTreeRep> list = new ArrayList<NodeTreeRep>(this.nodes.getChildCount());
            for (int i = 0; i < this.nodes.getChildCount(); ++i) {
                list.add((NodeTreeRep)this.nodes.getChildAt(i));
            }
            list.sort(this.getSorter());
            this.nodes.removeAllChildren();
            for (NodeTreeRep ch : list) {
                this.nodes.add(ch);
            }
            this.treeModel.nodeStructureChanged(this.nodes);
        }
    }

    Comparator<NodeTreeRep> getSorter() {
        return new Sorter(this.sortOrder);
    }

    public void release() {
        this.timer.cancel();
    }

    public static class Sorter
    implements Comparator<NodeTreeRep> {
        private final SortOrder sortOrder;

        public Sorter(SortOrder order) {
            this.sortOrder = order;
        }

        private String findCompareKey(MimicNodeStore.NodeMemo memo) {
            SimpleNodeIdent ident = memo.getSimpleNodeIdent();
            if (ident == null) {
                return null;
            }
            String s = null;
            String t = null;
            switch (this.sortOrder) {
                case BY_NODE_ID: {
                    return null;
                }
                case BY_NAME: {
                    s = ident.getUserName();
                    t = ident.getUserDesc();
                    break;
                }
                case BY_DESCRIPTION: {
                    s = ident.getUserDesc();
                    t = ident.getUserName();
                    break;
                }
                case BY_MODEL: {
                    s = ident.getMfgName();
                    t = ident.getModelName();
                }
            }
            if (s == null) {
                s = "";
            }
            if (t == null) {
                t = "";
            }
            if (s.isEmpty() && t.isEmpty()) {
                return null;
            }
            return s + "\u0000" + t;
        }

        @Override
        public int compare(MimicNodeStore.NodeMemo m1, MimicNodeStore.NodeMemo m2) {
            String entry1 = this.findCompareKey(m1);
            String entry2 = this.findCompareKey(m2);
            if (entry1 == null && entry2 == null) {
                return m1.getNodeID().toString().compareTo(m2.getNodeID().toString());
            }
            if (entry1 == null) {
                return 1;
            }
            if (entry2 == null) {
                return -1;
            }
            int cc = entry1.compareTo(entry2);
            if (cc != 0) {
                return cc;
            }
            return m1.getNodeID().toString().compareTo(m2.getNodeID().toString());
        }

        @Override
        public int compare(NodeTreeRep n1, NodeTreeRep n2) {
            MimicNodeStore.NodeMemo m1 = n1.memo;
            MimicNodeStore.NodeMemo m2 = n2.memo;
            return this.compare(m1, m2);
        }
    }

    public static enum SortOrder {
        BY_NODE_ID,
        BY_NAME,
        BY_DESCRIPTION,
        BY_MODEL;

    }
}

