/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing.memconfig;

import java.awt.FlowLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.implementations.MemoryConfigurationService;

public class MemConfigDescriptionPane
extends JPanel {
    private static final long serialVersionUID = 8566678220280469687L;
    private static final Logger logger = Logger.getLogger(MemConfigDescriptionPane.class.getName());
    NodeID node;
    MimicNodeStore store;
    MemoryConfigurationService service;
    JLabel commandLabel = new JLabel("       ");
    JLabel highSpaceLabel = new JLabel("       ");
    JLabel lowSpaceLabel = new JLabel("       ");

    public MemConfigDescriptionPane(NodeID node, MimicNodeStore store, MemoryConfigurationService service) {
        this.node = node;
        this.store = store;
        this.service = service;
        this.setLayout(new BoxLayout(this, 1));
        this.addLine(this.commandLabel, "Commands:");
        this.addLine(this.highSpaceLabel, "High Address Space:");
        this.addLine(this.lowSpaceLabel, "Low Address Space:");
        this.add(new JSeparator());
    }

    void addLine(JComponent j, String name) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(name));
        p.add(j);
        this.add(p);
    }

    public void initComponents() {
        MemoryConfigurationService.McsConfigMemo memo = new MemoryConfigurationService.McsConfigMemo(this.node){

            @Override
            public void handleFailure(int code) {
                logger.log(Level.SEVERE, "Failed to fetch MCS config information from node {0} error 0x{1}", new Object[]{MemConfigDescriptionPane.this.node, Integer.toHexString(code)});
                MemConfigDescriptionPane.this.commandLabel.setText("Failed: 0x" + Integer.toHexString(code));
            }

            @Override
            public void handleConfigData(NodeID dest, int commands, int lengths, int highSpace, int lowSpace, String name) {
                MemConfigDescriptionPane.this.commandLabel.setText("0x" + Utilities.toHexPair(commands >> 8) + Utilities.toHexPair(commands));
                MemConfigDescriptionPane.this.highSpaceLabel.setText("0x" + Utilities.toHexPair(highSpace));
                MemConfigDescriptionPane.this.lowSpaceLabel.setText("0x" + Utilities.toHexPair(lowSpace));
                MemConfigDescriptionPane.this.readSpace(dest, highSpace, lowSpace);
            }
        };
        this.service.request(memo);
    }

    void readSpace(NodeID dest, final int highSpace, final int lowSpace) {
        if (highSpace < lowSpace) {
            this.revalidate();
            if (this.getTopLevelAncestor() instanceof JFrame) {
                ((JFrame)this.getTopLevelAncestor()).pack();
            }
            return;
        }
        MemoryConfigurationService.McsAddrSpaceMemo memo = new MemoryConfigurationService.McsAddrSpaceMemo(this.node, highSpace){

            @Override
            public void handleAddrSpaceData(NodeID dest, int space, long hiAddress, long lowAddress, int flags, String desc) {
                JPanel p = new JPanel();
                p.setLayout(new FlowLayout());
                MemConfigDescriptionPane.this.add(p);
                p.add(new JLabel("Space: 0x" + Utilities.toHexPair(space)));
                p.add(new JLabel("High address: 0x" + Long.toHexString(hiAddress).toUpperCase()));
                MemConfigDescriptionPane.this.readSpace(dest, highSpace - 1, lowSpace);
            }
        };
        this.service.request(memo);
    }
}

