/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.openlcb.AbstractConnection;
import org.openlcb.Connection;
import org.openlcb.Message;

public class MonPane
extends JPanel {
    private static final long serialVersionUID = 6326460063811241070L;
    protected JButton clearButton = new JButton();
    protected JToggleButton freezeButton = new JToggleButton();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected JTextArea monTextPane = new JTextArea();
    protected JButton startLogButton = new JButton();
    protected JButton stopLogButton = new JButton();
    protected JCheckBox rawCheckBox = new JCheckBox();
    protected JCheckBox timeCheckBox = new JCheckBox();
    protected JButton openFileChooserButton = new JButton();
    protected JTextField entryField = new JTextField();
    protected JButton enterButton = new JButton();
    JFileChooser logFileChooser;
    MonPane self;
    private static final Logger logger = Logger.getLogger(MonPane.class.getName());
    String newline = System.getProperty("line.separator");
    PrintStream logStream = null;
    DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    StringBuffer linesBuffer = new StringBuffer();
    private static int MAX_LINES = 500;

    public MonPane() {
        this.self = this;
    }

    public void initComponents() {
        this.clearButton.setText("Clear screen");
        this.clearButton.setVisible(true);
        this.clearButton.setToolTipText("Clear monitoring history");
        this.freezeButton.setText("Freeze screen");
        this.freezeButton.setVisible(true);
        this.freezeButton.setToolTipText("Stop display scrolling");
        this.enterButton.setText("Add Message");
        this.enterButton.setVisible(true);
        this.enterButton.setToolTipText("Add a text message to the log");
        this.monTextPane.setVisible(true);
        this.monTextPane.setToolTipText("Command and reply monitoring information appears here");
        this.monTextPane.setEditable(false);
        JTextField t = new JTextField(80);
        int x = this.jScrollPane1.getPreferredSize().width + t.getPreferredSize().width;
        int y = this.jScrollPane1.getPreferredSize().height + 10 * t.getPreferredSize().height;
        this.jScrollPane1.getViewport().add(this.monTextPane);
        this.jScrollPane1.setPreferredSize(new Dimension(x, y));
        this.jScrollPane1.setVisible(true);
        this.startLogButton.setText("Start logging");
        this.startLogButton.setVisible(true);
        this.startLogButton.setToolTipText("start logging to file");
        this.stopLogButton.setText("Stop logging");
        this.stopLogButton.setVisible(true);
        this.stopLogButton.setToolTipText("Stop logging to file");
        this.rawCheckBox.setText("Show raw data");
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText("If checked, show the raw traffic in hex");
        this.timeCheckBox.setText("Show timestamps");
        this.timeCheckBox.setVisible(true);
        this.timeCheckBox.setToolTipText("If checked, show timestamps before each message");
        this.openFileChooserButton.setText("Choose log file");
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setToolTipText("Click here to select a new output log file");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.jScrollPane1);
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        pane1.add(this.clearButton);
        pane1.add(this.freezeButton);
        pane1.add(this.rawCheckBox);
        pane1.add(this.timeCheckBox);
        paneA.add(pane1);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 0));
        pane2.add(this.openFileChooserButton);
        pane2.add(this.startLogButton);
        pane2.add(this.stopLogButton);
        paneA.add(pane2);
        this.add(paneA);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonPane.this.clearButtonActionPerformed(e);
            }
        });
        this.startLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonPane.this.startLogButtonActionPerformed(e);
            }
        });
        this.stopLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonPane.this.stopLogButtonActionPerformed(e);
            }
        });
        this.openFileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonPane.this.openFileChooserButtonActionPerformed(e);
            }
        });
        this.enterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonPane.this.enterButtonActionPerformed(e);
            }
        });
        this.setFileChooser();
        if (this.logFileChooser == null) {
            this.openFileChooserButton.setEnabled(false);
            this.openFileChooserButton.setVisible(false);
        }
    }

    void setFileChooser() {
        try {
            if (this.logFileChooser == null) {
                this.logFileChooser = new JFileChooser();
                this.logFileChooser.setSelectedFile(new File("monitorLog.txt"));
            }
        }
        catch (Exception e) {
            this.logFileChooser = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLine(String line, String raw) {
        StringBuffer sb = new StringBuffer(120);
        if (this.timeCheckBox.isSelected()) {
            sb.append(this.df.format(new Date())).append(": ");
        }
        if (this.rawCheckBox.isSelected()) {
            sb.append('[').append(raw).append("]  ");
        }
        sb.append(line);
        MonPane monPane = this.self;
        synchronized (monPane) {
            this.linesBuffer.append(sb.toString());
        }
        if (!this.freezeButton.isSelected()) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MonPane monPane = MonPane.this.self;
                    synchronized (monPane) {
                        MonPane.this.monTextPane.append(MonPane.this.linesBuffer.toString());
                        int LineCount = MonPane.this.monTextPane.getLineCount();
                        if (LineCount > MAX_LINES) {
                            LineCount -= MAX_LINES;
                            try {
                                int offset = MonPane.this.monTextPane.getLineStartOffset(LineCount);
                                MonPane.this.monTextPane.getDocument().remove(0, offset);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        MonPane.this.linesBuffer.setLength(0);
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.logStream != null) {
            String logLine = sb.toString();
            if (!this.newline.equals("\n")) {
                int i = 0;
                int lim = sb.length();
                StringBuffer out = new StringBuffer(sb.length() + 10);
                for (i = 0; i < lim; ++i) {
                    if (sb.charAt(i) == '\n') {
                        out.append(this.newline);
                        continue;
                    }
                    out.append(sb.charAt(i));
                }
                logLine = new String(out);
            }
            this.logStream.print(logLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearButtonActionPerformed(ActionEvent e) {
        StringBuffer stringBuffer = this.linesBuffer;
        synchronized (stringBuffer) {
            this.linesBuffer.setLength(0);
            this.monTextPane.setText("");
        }
    }

    public synchronized void startLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream == null) {
            try {
                this.setFileChooser();
                if (this.logFileChooser != null) {
                    this.logStream = new PrintStream((OutputStream)new FileOutputStream(this.logFileChooser.getSelectedFile()), true, "ISO-8859-1");
                }
            }
            catch (Exception ex) {
                logger.severe("exception " + ex);
            }
        }
    }

    public synchronized void stopLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream.close();
        }
        this.logStream = null;
    }

    public void openFileChooserButtonActionPerformed(ActionEvent e) {
        this.setFileChooser();
        if (this.logFileChooser == null) {
            return;
        }
        int retVal = this.logFileChooser.showSaveDialog(this);
        if (retVal == 0) {
            boolean loggingNow = this.logStream != null;
            this.stopLogButtonActionPerformed(e);
            if (loggingNow) {
                this.startLogButtonActionPerformed(e);
            }
        }
    }

    public void enterButtonActionPerformed(ActionEvent e) {
        this.nextLine(this.entryField.getText() + "\n", "");
    }

    public synchronized String getFrameText() {
        return new String(this.linesBuffer);
    }

    public Connection getConnection() {
        return new InputLink();
    }

    class InputLink
    extends AbstractConnection {
        @Override
        public void put(Message msg, Connection sender) {
            MonPane.this.nextLine(msg.toString() + "\n", "");
        }
    }
}

