/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public class EventIdTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 44833863963351863L;
    private static final Logger logger = Logger.getLogger(EventIdTextField.class.getName());

    public static JFormattedTextField getEventIdTextField() {
        JFormattedTextField retval = new JFormattedTextField(EventIdTextField.createFormatter("HH.HH.HH.HH.HH.HH.HH.HH"));
        retval.setValue("DD.DD.DD.DD.DD.DD.DD.DD");
        retval.setPreferredSize(retval.getPreferredSize());
        retval.setValue("00.00.00.00.00.00.00.00");
        retval.setToolTipText("EventID as eight-byte dotted-hex string, e.g. 01.02.0A.AB.34.56.78.00");
        retval.setDragEnabled(true);
        retval.setTransferHandler(new CustomTransferHandler());
        return retval;
    }

    private static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            logger.log(Level.SEVERE, "formatter is bad: {0}", exc.getMessage());
        }
        return formatter;
    }

    static class CustomTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 3749257357774177433L;

        CustomTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new StringSelection(((JTextComponent)c).getSelectedText());
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport ts) {
            return ts.getComponent() instanceof JTextComponent;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport ts) {
            try {
                ((JTextComponent)ts.getComponent()).setText((String)ts.getTransferable().getTransferData(DataFlavor.stringFlavor));
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

