/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openlcb.implementations.SingleConsumerNode;

public class ConsumerPane
extends JPanel {
    private static final long serialVersionUID = 4037237914141482534L;
    static final int DELAY = 2000;
    private static final Logger logger = Logger.getLogger(ConsumerPane.class.getName());
    String name;
    protected JLabel sendLabel = new JLabel();
    Timer timer = new Timer(2000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsumerPane.this.sendLabel.setBackground(new JLabel().getBackground());
            ConsumerPane.this.sendLabel.repaint();
        }
    });

    public ConsumerPane(String name, SingleConsumerNode node) {
        this.name = name;
        if (name != null) {
            this.sendLabel.setText(name);
        } else {
            this.sendLabel.setText(node.getEventID().toString());
        }
        this.sendLabel.setVisible(true);
        this.sendLabel.setOpaque(true);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.sendLabel);
        this.timer.setRepeats(false);
        node.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Event")) {
                    ConsumerPane.this.sendLabel.setBackground(Color.gray);
                    ConsumerPane.this.sendLabel.repaint();
                    ConsumerPane.this.timer.start();
                } else if (e.getPropertyName().equals("EventID")) {
                    if (ConsumerPane.this.name == null) {
                        ConsumerPane.this.sendLabel.setText(e.getNewValue().toString());
                    }
                    logger.log(Level.FINE, "new {0}", e.getNewValue());
                }
            }
        });
    }
}

