/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.protocols;

import org.openlcb.EventID;
import org.openlcb.NodeID;
import org.openlcb.PropertyListenerSupport;

public interface TimeProtocol
extends PropertyListenerSupport {
    public static final NodeID DEFAULT_CLOCK = new NodeID(new byte[]{1, 1, 0, 0, 1, 0});
    public static final NodeID DEFAULT_RT_CLOCK = new NodeID(new byte[]{1, 1, 0, 0, 1, 1});
    public static final NodeID ALT_CLOCK_1 = new NodeID(new byte[]{1, 1, 0, 0, 1, 2});
    public static final NodeID ALT_CLOCK_2 = new NodeID(new byte[]{1, 1, 0, 0, 1, 3});
    public static final String PROP_TIME_UPDATE = "TimeUpdated";
    public static final String PROP_RATE_UPDATE = "RateUpdated";
    public static final String PROP_RUN_UPDATE = "RunUpdated";
    public static final int NIB_TIME_REPORT = 0;
    public static final int NIB_TIME_REPORT_ALT = 1;
    public static final int NIB_DATE_REPORT = 2;
    public static final int NIB_YEAR_REPORT = 3;
    public static final int NIB_RATE_REPORT = 4;
    public static final int NIB_SET = 8;
    public static final int QUERY_SUFFIX = 61440;
    public static final int STOP_SUFFIX = 61441;
    public static final int START_SUFFIX = 61442;
    public static final int DATE_ROLLOVER = 61443;
    public static final int SET_SUFFIX = 32768;

    public static int decodeClock(EventID event, NodeID expectedClock) {
        if (!event.startsWith(expectedClock)) {
            return -1;
        }
        byte[] cnt = event.getContents();
        int r = cnt[6];
        r &= 0xFF;
        r <<= 8;
        return r |= cnt[7] & 0xFF;
    }

    public static EventID createClockEvent(NodeID clock, int suffix) {
        return new EventID(clock, suffix >> 8 & 0xFF, suffix & 0xFF);
    }

    public static int createYear(int year) {
        return 0x3000 | year & 0xFFF;
    }

    public static int createMonthDay(int month, int day) {
        return 0x2000 | (month & 0xF) << 8 | day & 0xFF;
    }

    public static int createHourMin(int hrs, int min) {
        return 0 | (hrs & 0x1F) << 8 | min & 0xFF;
    }

    public static int createRate(double rate) {
        int r4 = (int)(rate * 4.0);
        if (r4 > 2047) {
            r4 = 2047;
        }
        if (r4 < -2048) {
            r4 = -2048;
        }
        return 0x4000 | r4 & 0xFFF;
    }

    public static double decodeRate(int suffix) {
        int ir = suffix & 0xFFF;
        ir <<= 20;
        double r = ir >>= 20;
        return r /= 4.0;
    }

    public double getRate();

    public boolean isRunning();

    public long getTimeInMsec();

    public void requestSetRate(double var1);

    public void requestStop();

    public void requestStart();

    public void requestSetTime(long var1);

    public void requestQuery();
}

