/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.protocols;

class TimeKeeper {
    boolean isRunning = true;
    long realTimeAnchor;
    long matchingFastTime = this.realTimeAnchor = this.currentTimeMillis();
    double rate = 1.0;

    TimeKeeper() {
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public synchronized long getTime() {
        return this.translateRealToFastTime(this.currentTimeMillis());
    }

    public synchronized void setTime(long fastTime) {
        this.realTimeAnchor = this.currentTimeMillis();
        this.matchingFastTime = fastTime;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        long currentRealTime = this.currentTimeMillis();
        this.matchingFastTime = this.translateRealToFastTime(currentRealTime);
        this.isRunning = false;
    }

    public synchronized void start() {
        if (this.isRunning) {
            return;
        }
        this.realTimeAnchor = this.currentTimeMillis();
        this.isRunning = true;
    }

    public synchronized void setRate(double r) {
        if (this.rate == r) {
            return;
        }
        long currentRealTime = this.currentTimeMillis();
        long curentFastTime = this.translateRealToFastTime(currentRealTime);
        this.realTimeAnchor = currentRealTime;
        this.matchingFastTime = curentFastTime;
        this.rate = r;
    }

    public synchronized long translateFastToRealTime(long fastTime) {
        if (!this.isRunning || this.rate == 0.0) {
            return -1L;
        }
        long deltaFastTime = fastTime - this.matchingFastTime;
        long deltaRealTime = (long)((double)deltaFastTime / this.rate);
        return this.realTimeAnchor + deltaRealTime;
    }

    public synchronized long translateRealToFastTime(long realTime) {
        if (!this.isRunning) {
            return this.matchingFastTime;
        }
        long deltaRealTime = realTime - this.realTimeAnchor;
        long deltaFastTime = (long)((double)deltaRealTime * this.rate);
        return this.matchingFastTime + deltaFastTime;
    }
}

