/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.protocols;

import java.util.Calendar;
import java.util.TimeZone;
import org.openlcb.Connection;
import org.openlcb.ConsumerRangeIdentifiedMessage;
import org.openlcb.DefaultPropertyListenerSupport;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.ProducerRangeIdentifiedMessage;
import org.openlcb.protocols.TimeKeeper;
import org.openlcb.protocols.TimeProtocol;

public class TimeBroadcastConsumer
extends DefaultPropertyListenerSupport
implements TimeProtocol {
    private final Handler messageHandler = new Handler();
    private Calendar lastReportedTime = Calendar.getInstance();
    private TimeZone timeZone = TimeZone.getDefault();
    private final OlcbInterface iface;
    private final NodeID clock;
    TimeKeeper timeKeeper;

    public TimeBroadcastConsumer(OlcbInterface iface, NodeID clock) {
        this.clock = clock;
        this.timeKeeper = new TimeKeeper();
        this.iface = iface;
        iface.registerMessageListener(this.messageHandler);
        iface.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                TimeBroadcastConsumer.this.sendStartupAction();
            }
        });
        this.lastReportedTime.set(13, 0);
        this.lastReportedTime.set(14, 0);
    }

    private void sendStartupAction() {
        int consumerSuffix = (this.clock.getContents()[5] & 1) == 0 ? 65535 : 0;
        this.iface.getOutputConnection().put(new ConsumerRangeIdentifiedMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, consumerSuffix)), this.messageHandler);
        int producerSuffix = 32768;
        this.iface.getOutputConnection().put(new ProducerRangeIdentifiedMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, producerSuffix)), this.messageHandler);
        this.requestQuery();
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
        this.lastReportedTime.setTimeZone(tz);
        this.lastReportedTime.setTimeInMillis(-15768000000000L);
    }

    public void dispose() {
        this.iface.unRegisterMessageListener(this.messageHandler);
    }

    public NodeID getClockID() {
        return this.clock;
    }

    private void handleTimeEvent(int d, boolean force) {
        switch (d) {
            case 61441: {
                boolean lastRunning = this.timeKeeper.isRunning;
                this.timeKeeper.stop();
                this.firePropertyChange("RunUpdated", lastRunning, false);
                break;
            }
            case 61442: {
                boolean lastRunning = this.timeKeeper.isRunning;
                this.timeKeeper.start();
                this.firePropertyChange("RunUpdated", lastRunning, true);
                break;
            }
            case 61443: {
                if (this.timeKeeper.rate >= 0.0) {
                    this.lastReportedTime.add(5, 1);
                    break;
                }
                this.lastReportedTime.add(5, -1);
            }
        }
        switch (d >> 12) {
            case 0: 
            case 1: {
                int hrs = d >> 8;
                int min = d & 0xFF;
                this.setHoursMins(hrs, min, force);
                break;
            }
            case 2: {
                int month = d >> 8 & 0xF;
                int day = d & 0xFF;
                this.setDate(month, day, force);
                break;
            }
            case 3: {
                int year = d & 0xFFF;
                this.setYear(year, force);
                break;
            }
            case 4: {
                double r = TimeProtocol.decodeRate(d);
                this.updateRate(r);
                break;
            }
        }
    }

    private void setHoursMins(int hrs, int min, boolean force) {
        Calendar c = this.lastReportedTime;
        c.set(11, hrs);
        c.set(12, min);
        long newTime = c.getTimeInMillis();
        long ctime = this.timeKeeper.getTime();
        if (Math.abs(ctime - newTime) > 120000L || force) {
            this.updateTime(newTime);
        }
    }

    private void setDate(int month, int day, boolean force) {
        Calendar c = this.lastReportedTime;
        c.set(2, month - 1);
        c.set(5, day);
        if (force) {
            c = Calendar.getInstance(this.timeZone);
            long ctime = this.timeKeeper.getTime();
            c.setTimeInMillis(ctime);
            c.set(2, month - 1);
            c.set(5, day);
            long newTime = c.getTimeInMillis();
            if (Math.abs(newTime - ctime) > 60000L) {
                this.updateTime(newTime);
            }
        }
    }

    private void updateRate(double r) {
        double oldRate = this.timeKeeper.rate;
        this.timeKeeper.setRate(r);
        this.firePropertyChange("RateUpdated", oldRate, r);
    }

    private void updateTime(long newTime) {
        long oldTime = this.timeKeeper.getTime();
        this.timeKeeper.setTime(newTime);
        this.firePropertyChange("TimeUpdated", oldTime, newTime);
    }

    private void setYear(int year, boolean force) {
        Calendar c = this.lastReportedTime;
        c.set(1, year);
        if (force) {
            long ctime = this.timeKeeper.getTime();
            c = Calendar.getInstance(this.timeZone);
            c.setTimeInMillis(ctime);
            c.set(1, year);
            long newTime = c.getTimeInMillis();
            if (Math.abs(newTime - ctime) > 60000L) {
                this.updateTime(newTime);
            }
        }
    }

    @Override
    public double getRate() {
        return this.timeKeeper.rate;
    }

    @Override
    public boolean isRunning() {
        return this.timeKeeper.isRunning;
    }

    @Override
    public long getTimeInMsec() {
        return this.timeKeeper.getTime();
    }

    @Override
    public void requestSetRate(double rate) {
        int sf = TimeProtocol.createRate(rate) | 0x8000;
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, sf)), this.messageHandler);
    }

    @Override
    public void requestStop() {
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, 61441)), this.messageHandler);
    }

    @Override
    public void requestStart() {
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, 61442)), this.messageHandler);
    }

    @Override
    public void requestSetTime(long timeMsec) {
        Calendar s = Calendar.getInstance(this.timeZone);
        s.setTimeInMillis(timeMsec);
        int year = s.get(1);
        int sf = TimeProtocol.createYear(year) | 0x8000;
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, sf)), this.messageHandler);
        int month = s.get(2);
        int day = s.get(5);
        sf = TimeProtocol.createMonthDay(month + 1, day) | 0x8000;
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, sf)), this.messageHandler);
        int hrs = s.get(11);
        int mins = s.get(12);
        sf = TimeProtocol.createHourMin(hrs, mins) | 0x8000;
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, sf)), this.messageHandler);
    }

    @Override
    public void requestQuery() {
        this.iface.getOutputConnection().put(new ProducerConsumerEventReportMessage(this.iface.getNodeId(), TimeProtocol.createClockEvent(this.clock, 61440)), this.messageHandler);
    }

    private class Handler
    extends MessageDecoder {
        private Handler() {
        }

        @Override
        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            int d = TimeProtocol.decodeClock(msg.getEventID(), TimeBroadcastConsumer.this.clock);
            if (d < 0) {
                return;
            }
            TimeBroadcastConsumer.this.handleTimeEvent(d, true);
        }

        @Override
        public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
            int d = TimeProtocol.decodeClock(msg.getEventID(), TimeBroadcastConsumer.this.clock);
            if (d < 0) {
                return;
            }
            TimeBroadcastConsumer.this.handleTimeEvent(d, false);
        }
    }
}

