/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.messages;

import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.implementations.throttle.Float16;

@Immutable
@ThreadSafe
public class TractionControlRequestMessage
extends AddressedPayloadMessage {
    private static final Logger logger = Logger.getLogger(TractionControlRequestMessage.class.getName());
    public static final byte CMD_SET_SPEED = 0;
    public static final byte CMD_SET_FN = 1;
    public static final byte CMD_ESTOP = 2;
    public static final byte CMD_GET_SPEED = 16;
    public static final byte CMD_GET_FN = 17;
    public static final byte CMD_CONTROLLER = 32;
    public static final byte SUBCMD_CONTROLLER_ASSIGN = 1;
    public static final byte SUBCMD_CONTROLLER_RELEASE = 2;
    public static final byte SUBCMD_CONTROLLER_QUERY = 3;
    public static final byte SUBCMD_CONTROLLER_CHANGE = 4;
    public static final byte CMD_CONSIST = 48;
    public static final byte SUBCMD_CONSIST_ATTACH = 1;
    public static final byte SUBCMD_CONSIST_DETACH = 2;
    public static final byte SUBCMD_CONSIST_QUERY = 3;
    public static final int CONSIST_FLAG_REVERSE = 2;
    public static final int CONSIST_FLAG_FN0 = 4;
    public static final int CONSIST_FLAG_FNN = 8;
    public static final byte CMD_MGMT = 32;
    public static final byte SUBCMD_MGMT_RESERVE = 1;
    public static final byte SUBCMD_MGMT_RELEASE = 2;

    public TractionControlRequestMessage(NodeID source, NodeID dest, byte[] payload) {
        super(source, dest, payload);
        this.payload = (byte[])payload.clone();
    }

    public static TractionControlRequestMessage createSetSpeed(NodeID source, NodeID dest, boolean isForward, double speed) {
        if (isForward) {
            if (speed < 0.0) {
                speed = -speed;
            }
        } else if (speed >= 0.0) {
            speed = -speed;
        }
        Float16 sp = new Float16(speed, isForward);
        logger.finest("Traction set speed: isFwd=" + isForward + " speed " + speed + " set speed " + sp.getByte1() + "." + sp.getByte2());
        byte[] payload = new byte[]{0, sp.getByte1(), sp.getByte2()};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createGetSpeed(NodeID source, NodeID dest) {
        return new TractionControlRequestMessage(source, dest, new byte[]{16});
    }

    public static TractionControlRequestMessage createSetFn(NodeID source, NodeID dest, int fn, int val) {
        byte[] payload = new byte[]{1, (byte)(fn >> 16 & 0xFF), (byte)(fn >> 8 & 0xFF), (byte)(fn & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createGetFn(NodeID source, NodeID dest, int fn) {
        byte[] payload = new byte[]{17, (byte)(fn >> 16 & 0xFF), (byte)(fn >> 8 & 0xFF), (byte)(fn & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createAssignController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 1, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(source.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createReleaseController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 2, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(source.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createQueryController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 3};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createControllerChangeNotify(NodeID source, NodeID dest, NodeID newController) {
        byte[] payload = new byte[]{32, 4, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(newController.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistAttach(NodeID source, NodeID dest, NodeID consistEntry, int flags) {
        byte[] payload = new byte[]{48, 1, (byte)(flags & 0xFF), 1, 2, 3, 4, 5, 6};
        System.arraycopy(consistEntry.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistDetach(NodeID source, NodeID dest, NodeID consistEntry) {
        byte[] payload = new byte[]{48, 2, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(consistEntry.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistIndexQuery(NodeID source, NodeID dest, int index) {
        byte[] payload = new byte[]{48, 3, (byte)(index & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistLengthQuery(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{48, 3};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public byte getCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[0];
    }

    public byte getSubCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[1];
    }

    public Float16 getSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[1] << 8 | this.payload[2] & 0xFF);
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleTractionControlRequest(this, sender);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.TractionControlRequest;
    }
}

