/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.messages;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.implementations.throttle.Float16;

@Immutable
@ThreadSafe
public class TractionControlReplyMessage
extends AddressedPayloadMessage {
    private static final Logger logger = Logger.getLogger(TractionControlReplyMessage.class.getName());
    public static final byte CMD_GET_SPEED = 16;
    public static final byte CMD_GET_FN = 17;
    public static final byte CMD_CONTROLLER = 32;
    public static final byte SUBCMD_CONTROLLER_ASSIGN = 1;
    public static final byte SUBCMD_CONTROLLER_QUERY = 3;
    public static final byte SUBCMD_CONTROLLER_CHANGE = 4;
    public static final byte CMD_MGMT = 32;
    public static final byte SUBCMD_MGMT_RESERVE = 1;
    public static final byte CMD_CONSIST = 48;
    public static final byte SUBCMD_CONSIST_ATTACH = 1;
    public static final byte SUBCMD_CONSIST_DETACH = 2;
    public static final byte SUBCMD_CONSIST_QUERY = 3;

    public TractionControlReplyMessage(NodeID source, NodeID dest, byte[] payload) {
        super(source, dest, payload);
    }

    public byte getCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[0];
    }

    public byte getSubCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[1];
    }

    public byte getAssignControllerReply() throws ArrayIndexOutOfBoundsException {
        return this.payload[2];
    }

    public NodeID getCurrentControllerReply() throws ArrayIndexOutOfBoundsException {
        if (this.payload.length < 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] nid = new byte[6];
        System.arraycopy(this.payload, 3, nid, 0, 6);
        return new NodeID(nid);
    }

    public byte getReserveReply() throws ArrayIndexOutOfBoundsException {
        return this.payload[2];
    }

    public Float16 getSetSpeed() throws ArrayIndexOutOfBoundsException {
        Float16 f = new Float16(this.payload[1], this.payload[2]);
        logger.finest("Incoming float16 " + this.payload[1] + "." + this.payload[2] + "= " + f.getFloat());
        return f;
    }

    public Float16 getCommandedSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[4], this.payload[5]);
    }

    public Float16 getActualSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[6], this.payload[7]);
    }

    public int getFnNumber() {
        int retval = 0;
        retval = this.payload[1] & 0xFF;
        retval <<= 8;
        retval |= this.payload[2] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[3] & 0xFF;
    }

    public int getFnVal() {
        int retval = 0;
        retval = this.payload[4] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[5] & 0xFF;
    }

    public int getConsistLength() {
        int uintval = this.payload[2];
        int retval = uintval < 0 ? uintval + 256 : uintval;
        return retval;
    }

    public int getConsistIndex() {
        if (this.payload.length < 4) {
            return -1;
        }
        int uintval = this.payload[3];
        int retval = uintval < 0 ? uintval + 256 : uintval;
        return retval;
    }

    @Nullable
    public NodeID getConsistQueryNodeID() {
        if (this.payload.length < 11) {
            return null;
        }
        byte[] id = new byte[6];
        System.arraycopy(this.payload, 5, id, 0, 6);
        return new NodeID(id);
    }

    public int getConsistQueryFlags() {
        if (this.payload.length < 11) {
            return 0;
        }
        return this.payload[4];
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleTractionControlReply(this, sender);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.TractionControlReply;
    }
}

