/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import org.openlcb.CommonIdentifiers;
import org.openlcb.Connection;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.throttle.AbstractNodeCache;
import org.openlcb.implementations.throttle.RemoteTrainNode;

public class TrainNodeCache
extends AbstractNodeCache<RemoteTrainNode> {
    private final OlcbInterface iface;

    public TrainNodeCache(OlcbInterface _iface) {
        super(CommonIdentifiers.IS_TRAIN);
        this.iface = _iface;
        this.iface.registerMessageListener(this);
        this.iface.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                c.put(new IdentifyProducersMessage(TrainNodeCache.this.iface.getNodeId(), CommonIdentifiers.IS_TRAIN), TrainNodeCache.this);
            }
        });
    }

    public void release() {
        this.iface.unRegisterMessageListener(this);
    }

    @Override
    protected RemoteTrainNode newObject(NodeID id) {
        MimicNodeStore.NodeMemo memo = this.iface.getNodeStore().findNode(id);
        if (memo != null) {
            memo.getSimpleNodeIdent();
            memo.getProtocolIdentification();
        }
        return new RemoteTrainNode(id, this.iface);
    }

    public void flushCache() {
        for (RemoteTrainNode remoteNode : this.getList()) {
            remoteNode.flushCache();
        }
    }
}

