/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Reader;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.jdom2.Element;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.cdi.jdom.CdiMemConfigReader;
import org.openlcb.cdi.jdom.XmlHelper;

@Immutable
@ThreadSafe
public class RemoteTrainNode {
    public static final String UPDATE_PROP_FDI = "fdi";
    private static final Logger logger = Logger.getLogger(RemoteTrainNode.class.getName());
    private final OlcbInterface iface;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Element fdiRoot;
    private NodeID node;
    private String fdiXml = null;

    public RemoteTrainNode(NodeID node, OlcbInterface iface) {
        this.node = node;
        this.iface = iface;
    }

    public NodeID getNodeId() {
        return this.node;
    }

    public boolean hasFdiXml() {
        return this.fdiXml != null;
    }

    public synchronized void setFdiXmlCached(String payload) {
        if (this.fdiXml != null) {
            this.fdiXml = payload;
        }
    }

    public synchronized void flushCache() {
        this.fdiRoot = null;
    }

    public synchronized Element getFdiXml() {
        if (this.fdiRoot != null) {
            return this.fdiRoot;
        }
        new CdiMemConfigReader(this.node, this.iface, 250).startLoadReader(new CdiMemConfigReader.ReaderAccess(){

            @Override
            public void progressNotify(long bytesRead, long totalBytes) {
            }

            @Override
            public void provideReader(Reader r) {
                try {
                    RemoteTrainNode.this.fdiRoot = XmlHelper.parseXmlFromReader(r);
                }
                catch (Exception e) {
                    logger.warning("Unable to parse returned FDI from train " + RemoteTrainNode.this.node.toString());
                    e.printStackTrace();
                    return;
                }
                RemoteTrainNode.this.firePropertyChange(RemoteTrainNode.UPDATE_PROP_FDI, null, RemoteTrainNode.this.fdiRoot);
            }
        });
        return null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

