/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@Immutable
@ThreadSafe
public class Float16 {
    private static final Logger logger = Logger.getLogger(Float16.class.getName());
    byte byte1;
    byte byte2;

    public Float16(float f) {
        this(f, f >= 0.0f);
    }

    public Float16(double d) {
        this(d, d >= 0.0);
    }

    public Float16(double d, boolean positive) {
        if (d == 0.0) {
            this.byte1 = 0;
            if (!positive) {
                this.byte1 = (byte)-128;
            }
            this.byte2 = 0;
            return;
        }
        if (d < 0.0) {
            d = -1.0 * d;
        }
        int exp = 15;
        if (d < 1.0) {
            while (d < 1.0) {
                d = 2.0 * d;
                --exp;
            }
        } else {
            while (d >= 2.0) {
                d /= 2.0;
                ++exp;
            }
        }
        int ch = (int)(d * 1024.0) & 0x3FF;
        if (((int)(d * 1024.0) & 0x400) != 1024) {
            logger.log(Level.WARNING, "normalization failed with d={0} exp={1}", new Object[]{d, exp});
        }
        int bits = ch | exp << 10;
        if (!positive) {
            bits |= 0x8000;
        }
        this.byte1 = (byte)(bits >> 8 & 0xFF);
        this.byte2 = (byte)(bits & 0xFF);
    }

    public Float16(int i) {
        this.byte1 = (byte)(i >> 8 & 0xFF);
        this.byte2 = (byte)(i & 0xFF);
    }

    public Float16(byte b1, byte b2) {
        this.byte1 = b1;
        this.byte2 = b2;
    }

    public int getInt() {
        return (this.byte1 & 0xFF) << 8 | this.byte2 & 0xFF;
    }

    public byte getByte1() {
        return this.byte1;
    }

    public byte getByte2() {
        return this.byte2;
    }

    public float getFloat() {
        if (this.byte1 == 0 && this.byte2 == 0) {
            return 0.0f;
        }
        if (this.byte1 == -128 && this.byte2 == 0) {
            return -0.0f;
        }
        int ch = this.byte2 & 0xFF | (this.byte1 & 3) << 8 | 0x400;
        int exp = ((this.byte1 & 0x7C) >> 2) - 15;
        int sign = (this.byte1 & 0x80) != 0 ? -1 : 1;
        return (float)((double)ch / 1024.0 * Math.pow(2.0, exp)) * (float)sign;
    }
}

