/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class FdiParser {
    private static final Logger logger = Logger.getLogger(FdiParser.class.getName());
    private ArrayList<FunctionInfo> allFunctions = new ArrayList();

    public FdiParser(Element root) {
        for (Element segment : root.getChildren("segment")) {
            int space = FdiParser.getIntAttribute(segment, "space", 249);
            long offset = FdiParser.getIntAttribute(segment, "origin", 0).intValue();
            for (Element group : segment.getChildren("group")) {
                offset += (long)FdiParser.getIntAttribute(group, "offset", 0).intValue();
                for (Element fn : group.getChildren("function")) {
                    FunctionInfo fni = new FunctionInfo();
                    fni.segment = space;
                    Integer fnNum = FdiParser.getIntChild(fn, "number", null);
                    if (fnNum == null) {
                        logger.warning("Function with no number specified: " + fn.toString());
                        continue;
                    }
                    fni.fn = fnNum;
                    fni.name = fn.getChildText("name");
                    if (fni.name == null) {
                        fni.name = "F" + fni.fn;
                    }
                    fni.size = FdiParser.getIntAttribute(fn, "size", 1);
                    fni.offset = offset;
                    offset += (long)fni.size;
                    String type = fn.getAttributeValue("kind");
                    if (type == null) {
                        type = "toggle";
                    }
                    if (type.equals("momentary")) {
                        fni.fnType = FunctionType.MOMENTARY;
                    } else if (type.equals("toggle") || type.equals("binary")) {
                        fni.fnType = FunctionType.TOGGLE;
                    } else if (type.equals("analog")) {
                        fni.fnType = FunctionType.ANALOG;
                    } else {
                        logger.warning("Unknown function kind: '" + type + "'");
                        fni.fnType = FunctionType.TOGGLE;
                    }
                    this.allFunctions.add(fni);
                }
            }
        }
    }

    private static Integer getIntAttribute(Element el, String name, Integer defaultValue) {
        Attribute a = el.getAttribute(name);
        if (a == null) {
            return defaultValue;
        }
        try {
            return a.getIntValue();
        }
        catch (DataConversionException e) {
            logger.info("Error parsing attribute " + name + " on element " + el.getName() + ": unparseable integer '" + a.getValue() + "'");
            return defaultValue;
        }
    }

    private static Integer getIntChild(Element el, String name, Integer defaultValue) {
        String value = el.getChildText(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info("Error parsing element " + name + " on parent " + el.getName() + ": unparseable integer '" + value + "'");
            return defaultValue;
        }
    }

    public List<FunctionInfo> getAllFunctions() {
        return this.allFunctions;
    }

    public class FunctionInfo {
        int segment;
        long offset;
        int size;
        int fn;
        String name;
        FunctionType fnType;

        public int getSpace() {
            return this.segment;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public int getFn() {
            return this.fn;
        }

        public String getName() {
            return this.name;
        }

        public FunctionType getType() {
            return this.fnType;
        }
    }

    public static enum FunctionType {
        MOMENTARY,
        TOGGLE,
        ANALOG;

    }
}

