/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;
import org.openlcb.implementations.VersionOutOfDateException;

public class VersionedValue<T> {
    T data;
    int version;
    int nextVersion;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static int DEFAULT_VERSION = 1;
    private int defaultVersion = DEFAULT_VERSION;
    private static final Logger log = Logger.getLogger(VersionedValue.class.getCanonicalName());

    public VersionedValue(T t) {
        this.version = DEFAULT_VERSION;
        this.nextVersion = DEFAULT_VERSION + 1;
        this.data = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewVersion() {
        int newVersion;
        VersionedValue versionedValue = this;
        synchronized (versionedValue) {
            newVersion = ++this.nextVersion;
        }
        return newVersion;
    }

    public synchronized void setVersionToDefault() {
        this.defaultVersion = this.version;
    }

    public synchronized boolean isVersionAtDefault() {
        return this.version == this.defaultVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T t) {
        int version;
        VersionedValue versionedValue = this;
        synchronized (versionedValue) {
            version = this.getNewVersion();
        }
        this.set(version, t);
    }

    public boolean setWithForceNotify(int atVersion, T t) {
        return this.setInternal(atVersion, t, true);
    }

    public boolean set(int atVersion, T t) {
        return this.setInternal(atVersion, t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInternal(int atVersion, T t, boolean forceNotify) {
        T old;
        boolean updated = false;
        VersionedValue versionedValue = this;
        synchronized (versionedValue) {
            if (atVersion <= this.version) {
                return false;
            }
            int oldVersion = this.version;
            this.version = atVersion;
            if (this.nextVersion <= atVersion) {
                this.nextVersion = atVersion + 1;
            }
            if (this.data.equals(t) && oldVersion != this.defaultVersion && !forceNotify) {
                return true;
            }
            old = this.data;
            if (oldVersion == this.defaultVersion || forceNotify) {
                old = null;
            }
            this.data = t;
        }
        this.firePropertyChange("updated", old, t);
        return true;
    }

    public T getLatestData() {
        return this.data;
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized T getDataForVersion(int expectedVersion) throws VersionOutOfDateException {
        if (this.version != expectedVersion) {
            throw new VersionOutOfDateException();
        }
        return this.data;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

