/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import org.openlcb.AddressedMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.StreamDataCompleteMessage;
import org.openlcb.StreamDataProceedMessage;
import org.openlcb.StreamDataSendMessage;
import org.openlcb.StreamInitiateReplyMessage;
import org.openlcb.StreamInitiateRequestMessage;

public class StreamTransmitter
extends MessageDecoder {
    NodeID here;
    NodeID far;
    int bufferSize;
    int[] bytes;
    Connection connection;
    int nextIndex;
    byte destStreamID;
    byte sourceStreamID = (byte)4;

    public StreamTransmitter(NodeID here, NodeID far, int bufferSize, int[] bytes, Connection c) {
        this.here = here;
        this.far = far;
        this.bufferSize = bufferSize;
        this.bytes = bytes;
        this.connection = c;
        this.destStreamID = 0;
        StreamInitiateRequestMessage m = new StreamInitiateRequestMessage(here, far, bufferSize, this.sourceStreamID, this.destStreamID);
        this.connection.put(m, this);
    }

    @Override
    public void handleStreamInitiateReply(StreamInitiateReplyMessage msg, Connection sender) {
        this.bufferSize = msg.getBufferSize();
        this.destStreamID = msg.getDestinationStreamID();
        this.nextIndex = 0;
        this.sendNext();
    }

    void sendNext() {
        int size = Math.min(this.bufferSize, this.bytes.length - this.nextIndex);
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.bytes[this.nextIndex + i];
        }
        this.nextIndex += size;
        AddressedMessage m = new StreamDataSendMessage(this.here, this.far, this.destStreamID, data);
        this.connection.put(m, this);
        if (this.nextIndex < this.bytes.length) {
            return;
        }
        m = new StreamDataCompleteMessage(this.here, this.far, this.sourceStreamID, this.destStreamID);
        this.connection.put(m, this);
    }

    @Override
    public void handleStreamDataProceed(StreamDataProceedMessage msg, Connection sender) {
        this.sendNext();
    }
}

