/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.EventState;
import org.openlcb.NodeID;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.SingleLinkNode;

public class SingleConsumerNode
extends SingleLinkNode {
    EventID eventID;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    boolean received = false;

    public SingleConsumerNode(NodeID node, Connection connection, EventID eventID) {
        super(node, connection);
        if (eventID == null) {
            throw new IllegalArgumentException("EventID cannot be null");
        }
        this.eventID = eventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setEventID(EventID eid) {
        this.eventID = eid;
        this.firePropertyChange("EventID", null, this.eventID);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.connection.put(new ConsumerIdentifiedMessage(this.nodeID, this.eventID, EventState.Unknown), this);
    }

    @Override
    public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
        if (msg.getEventID().equals(this.eventID)) {
            this.received = true;
            this.firePropertyChange("Event", null, msg);
        }
    }

    public boolean getReceived() {
        boolean retval = this.received;
        this.received = false;
        return retval;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

