/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.FailureCallback;
import org.openlcb.NoReturnCallback;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.DatagramUtils;

public class MemoryConfigurationService {
    private static final Logger logger = Logger.getLogger(MemoryConfigurationService.class.getName());
    private static final int DATAGRAM_TYPE = 32;
    public static final int SPACE_CDI = 255;
    public static final int SPACE_ALL_MEM = 254;
    public static final int SPACE_CONFIG = 253;
    public static final int SPACE_ACDI_CONST = 252;
    public static final int SPACE_ACDI_USER = 251;
    public static final int SPACE_TRACTION_FDI = 250;
    public static final int SPACE_TRACTION_FUNCTION = 249;
    private static final int SUBCMD_REPLY = 16;
    private static final int SUBCMD_ERROR = 8;
    private static final int SUBCMD_WRITE = 0;
    private static final int SUBCMD_WRITE_STREAM = 32;
    private static final int SUBCMD_READ = 64;
    private static final int SUBCMD_READ_STREAM = 96;
    private static final long TIMEOUT = 3000L;
    private long timeoutMillis = 3000L;
    private static final long MAX_TRIES = 3L;
    NodeID here;
    DatagramService downstream;
    private Timer retryTimer;
    final Map<Integer, McsRequestMemo> pendingRequests = new HashMap<Integer, McsRequestMemo>(5);
    final Map<Integer, ArrayDeque<McsRequestMemo>> queuedRequests = new HashMap<Integer, ArrayDeque<McsRequestMemo>>(5);
    McsWriteStreamMemo writeStreamMemo;
    McsConfigMemo configMemo;
    McsAddrSpaceMemo addrSpaceMemo;

    public MemoryConfigurationService(NodeID here, DatagramService downstream) {
        this.retryTimer = new Timer("OpenLCB Memory Configuration Service Retry Timer");
        this.here = here;
        this.downstream = downstream;
        downstream.registerForReceive(new DatagramService.DatagramServiceReceiveMemo(32){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void handleData(NodeID dest, int[] data, DatagramService.ReplyMemo service) {
                service.acceptData(0);
                if (MemoryConfigurationService.this.addrSpaceMemo != null) {
                    int space = data[2] & 0xFF;
                    long highAddress = ((long)data[3] & 0xFFL) << 24 | ((long)data[4] & 0xFFL) << 16 | ((long)data[5] & 0xFFL) << 8 | (long)data[6] & 0xFFL;
                    int flags = data[7] & 0xFF;
                    long lowAddress = 0L;
                    if (data.length >= 11) {
                        lowAddress = ((long)data[8] & 0xFFL) << 24 | ((long)data[9] & 0xFFL) << 16 | ((long)data[10] & 0xFFL) << 8 | (long)data[11] & 0xFFL;
                    }
                    McsAddrSpaceMemo memo = MemoryConfigurationService.this.addrSpaceMemo;
                    MemoryConfigurationService.this.addrSpaceMemo = null;
                    memo.handleAddrSpaceData(dest, space, highAddress, lowAddress, flags, "");
                    return;
                }
                if (MemoryConfigurationService.this.configMemo != null) {
                    int commands = (data[2] << 8) + data[3];
                    int options = data[4];
                    int highSpace = data[5];
                    int lowSpace = data[6];
                    McsConfigMemo memo = MemoryConfigurationService.this.configMemo;
                    MemoryConfigurationService.this.configMemo = null;
                    memo.handleConfigData(dest, commands, options, highSpace, lowSpace, "");
                    return;
                }
                if (MemoryConfigurationService.this.writeStreamMemo != null) {
                    boolean spaceByte = (data[1] & 3) == 0;
                    int spaceOfs = spaceByte ? 1 : 0;
                    McsWriteStreamMemo memo = MemoryConfigurationService.this.writeStreamMemo;
                    MemoryConfigurationService.this.writeStreamMemo = null;
                    if ((data[1] & 8) == 0) {
                        memo.handleSuccess();
                    } else {
                        memo.handleFailure("WriteStreamReply", DatagramUtils.parseErrorCode(data, 6 + spaceOfs));
                    }
                    return;
                }
                int requestCode = MemoryConfigurationService.getRequestTypeFromResponseType(data[1]);
                RequestWithReplyDatagram memo = null;
                McsRequestMemo rqMemo = null;
                1 var7_14 = this;
                synchronized (var7_14) {
                    if (MemoryConfigurationService.this.pendingRequests.containsKey(requestCode)) {
                        rqMemo = MemoryConfigurationService.this.pendingRequests.get(requestCode);
                        if (!rqMemo.getDest().equals(dest)) {
                            logger.warning("Spurious MemCfg response datagram " + Utilities.toHexSpaceString(data) + ": expected source " + rqMemo.getDest() + " actual source " + dest);
                            MemoryConfigurationService.this.delayRetryMemo(rqMemo);
                            return;
                        }
                        if (!(rqMemo instanceof RequestWithReplyDatagram)) {
                            logger.warning("Spurious MemCfg response datagram " + Utilities.toHexSpaceString(data) + ": the request memo does not support response datagrams. Memo: " + rqMemo);
                            MemoryConfigurationService.this.delayRetryMemo(rqMemo);
                            return;
                        }
                        memo = (RequestWithReplyDatagram)((Object)rqMemo);
                        if (!memo.compareResponse(data)) {
                            logger.warning("Unexpected MemCfg response datagram from " + dest.toString() + ": " + memo + " payload " + Utilities.toHexSpaceString(data));
                            MemoryConfigurationService.this.delayRetryMemo(rqMemo);
                            return;
                        }
                        MemoryConfigurationService.this.checkAndPopMemo(rqMemo);
                    } else {
                        logger.warning("Could not find a matching memo for MemCfg response datagram from " + dest.toString() + " payload " + Utilities.toHexSpaceString(data));
                    }
                }
                if (memo != null) {
                    rqMemo.foundResponse = true;
                    memo.handleResponseDatagram(data);
                }
            }
        });
    }

    public MemoryConfigurationService(MemoryConfigurationService mcs) {
        this(mcs.here, mcs.downstream);
    }

    public void setTimeoutMillis(long t) {
        this.timeoutMillis = t;
    }

    public void waitForTimer() throws InterruptedException {
        final Semaphore s = new Semaphore(0);
        this.retryTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                s.release();
            }
        }, 1L);
        s.acquire();
    }

    public static int getSpaceFromPayload(int[] data) {
        if ((data[1] & 3) != 0) {
            return 252 + (data[1] & 3);
        }
        return data[6];
    }

    public static int getRequestTypeFromResponseType(int subCmd) {
        if (subCmd < 128) {
            return subCmd & 0xE0;
        }
        return subCmd & 0xFC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndPopMemo(McsRequestMemo memo) {
        int rqCode = memo.getRequestCode();
        MemoryConfigurationService memoryConfigurationService = this;
        synchronized (memoryConfigurationService) {
            if (this.pendingRequests.get(rqCode) == memo) {
                Queue l;
                this.pendingRequests.remove(memo.getRequestCode());
                memo = null;
                if (this.queuedRequests.containsKey(rqCode) && !(l = (Queue)this.queuedRequests.get(rqCode)).isEmpty()) {
                    memo = (McsRequestMemo)l.poll();
                    this.pendingRequests.put(rqCode, memo);
                }
            } else {
                logger.warning("Error checking the pending request memo for code " + rqCode + " expected " + memo.toString() + " actual " + this.pendingRequests.get(memo.getRequestCode()));
                memo = null;
            }
        }
        if (memo != null) {
            this.sendRequest(memo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBlockingPendingQueue(McsRequestMemo memo) {
        MemoryConfigurationService memoryConfigurationService = this;
        synchronized (memoryConfigurationService) {
            return this.pendingRequests.get(memo.getRequestCode()) == memo;
        }
    }

    private void delayRetryMemo(final McsRequestMemo memo) {
        if ((long)memo.numTries >= 3L) {
            this.checkAndPopMemo(memo);
            memo.failureCallback.handleFailure(4096);
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                if (memo.foundResponse) {
                    return;
                }
                if (!MemoryConfigurationService.this.isBlockingPendingQueue(memo)) {
                    return;
                }
                MemoryConfigurationService.this.sendRequest(memo);
            }
        };
        this.retryTimer.schedule(tt, this.timeoutMillis);
    }

    private void sendRequest(final McsRequestMemo memo) {
        ++memo.numTries;
        this.downstream.sendData(new DatagramService.DatagramServiceTransmitMemo(memo.getDest(), memo.renderTransmitDatagram()){

            @Override
            public void handleSuccess(int flags) {
                if (memo instanceof RequestWithNoReply && (flags & 0x80) == 0) {
                    MemoryConfigurationService.this.checkAndPopMemo(memo);
                    ((RequestWithNoReply)((Object)memo)).getNoReturnCallback().handleSuccess();
                    return;
                }
                if (memo instanceof RequestWithReplyDatagram && (flags & 0x80) != 0) {
                    return;
                }
                if (memo instanceof RequestWithReplyDatagram) {
                    logger.info("Expected reply pending, got zero.");
                    return;
                }
                logger.warning("The remote node wants to send a reply but we don't know how to handle it. memo: " + memo.toString());
                MemoryConfigurationService.this.checkAndPopMemo(memo);
                ((RequestWithNoReply)((Object)memo)).getNoReturnCallback().handleSuccess();
            }

            @Override
            public void handleFailure(int errorCode) {
                MemoryConfigurationService.this.checkAndPopMemo(memo);
                memo.failureCallback.handleFailure(errorCode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(McsRequestMemo memo) {
        MemoryConfigurationService memoryConfigurationService = this;
        synchronized (memoryConfigurationService) {
            int rqCode = memo.getRequestCode();
            if (this.pendingRequests.containsKey(rqCode)) {
                if (!this.queuedRequests.containsKey(rqCode)) {
                    this.queuedRequests.put(rqCode, new ArrayDeque());
                }
                this.queuedRequests.get(rqCode).add(memo);
                return;
            }
            this.pendingRequests.put(memo.getRequestCode(), memo);
        }
        this.sendRequest(memo);
    }

    public void requestWrite(NodeID dest, int space, long address, byte[] data, McsWriteHandler cb) {
        this.request(new McsWriteMemo(dest, space, address, data, cb));
    }

    public void requestRead(NodeID dest, int space, long address, int len, McsReadHandler cb) {
        this.request(new McsReadMemo(dest, space, address, len, cb));
    }

    public void request(McsWriteStreamMemo memo) {
        this.writeStreamMemo = memo;
        WriteStreamMemo dg = new WriteStreamMemo(memo.dest, memo.space, memo.address, memo.srcStreamId, memo);
        this.downstream.sendData(dg);
    }

    public void request(McsConfigMemo memo) {
        this.configMemo = memo;
        ConfigDatagramMemo dg = new ConfigDatagramMemo(memo.dest, memo);
        this.downstream.sendData(dg);
    }

    public void request(McsAddrSpaceMemo memo) {
        this.addrSpaceMemo = memo;
        AddrSpaceDatagramMemo dg = new AddrSpaceDatagramMemo(memo.dest, memo);
        this.downstream.sendData(dg);
    }

    private synchronized void checkAndPopConfigMemo(McsConfigMemo memo) {
        if (memo != this.configMemo) {
            logger.warning("Error checking the configMemo. Expected=" + memo + " actual=" + this.configMemo);
            return;
        }
        this.configMemo = null;
    }

    private synchronized void checkAndPopAddrspaceMemo(McsAddrSpaceMemo memo) {
        if (memo != this.addrSpaceMemo) {
            logger.warning("Error checking the addrspaceMemo. Expected=" + memo + " actual=" + this.addrSpaceMemo);
            return;
        }
        this.addrSpaceMemo = null;
    }

    public void dispose() {
        this.retryTimer.cancel();
    }

    @Immutable
    @ThreadSafe
    public static class AddrSpaceDatagramMemo
    extends DatagramService.DatagramServiceTransmitMemo {
        McsAddrSpaceMemo memo;

        AddrSpaceDatagramMemo(NodeID dest, McsAddrSpaceMemo memo) {
            super(dest);
            this.data = new int[3];
            this.data[0] = 32;
            this.data[1] = 132;
            this.data[2] = memo.space;
            this.memo = memo;
        }

        @Override
        public void handleSuccess(int flags) {
        }

        @Override
        public void handleFailure(int errorCode) {
        }

        public void handleReply(int code) {
            this.memo.handleWriteReply(code);
        }
    }

    @Immutable
    @ThreadSafe
    public static class McsAddrSpaceMemo {
        NodeID dest;
        int space;

        public McsAddrSpaceMemo(NodeID dest, int space) {
            this.dest = dest;
            this.space = space;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof McsAddrSpaceMemo)) {
                return false;
            }
            McsAddrSpaceMemo m = (McsAddrSpaceMemo)o;
            if (this.space != m.space) {
                return false;
            }
            return this.dest == m.dest;
        }

        public String toString() {
            return "McsAddrSpaceMemo " + this.space;
        }

        public int hashCode() {
            return this.dest.hashCode() + this.space;
        }

        public void handleWriteReply(int code) {
        }

        public void handleAddrSpaceData(NodeID dest, int space, long hiAddress, long lowAddress, int flags, String desc) {
        }
    }

    @Immutable
    @ThreadSafe
    public class ConfigDatagramMemo
    extends DatagramService.DatagramServiceTransmitMemo {
        McsConfigMemo memo;

        ConfigDatagramMemo(NodeID dest, McsConfigMemo memo) {
            super(dest);
            this.data = new int[2];
            this.data[0] = 32;
            this.data[1] = 128;
            this.memo = memo;
        }

        @Override
        public void handleSuccess(int flags) {
            if ((flags & 0x80) == 0) {
                logger.warning("MemConfig GetConfig datagram returned with no reply_pending bit set.");
            }
        }

        @Override
        public void handleFailure(int errorCode) {
            MemoryConfigurationService.this.checkAndPopConfigMemo(this.memo);
            this.memo.handleFailure(errorCode);
        }
    }

    @Immutable
    @ThreadSafe
    public static abstract class McsConfigMemo {
        final NodeID dest;

        public McsConfigMemo(NodeID dest) {
            this.dest = dest;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof McsConfigMemo)) {
                return false;
            }
            McsConfigMemo m = (McsConfigMemo)o;
            return this.dest == m.dest;
        }

        public String toString() {
            return "McsConfigMemo";
        }

        public int hashCode() {
            return this.dest.hashCode();
        }

        public abstract void handleFailure(int var1);

        public void handleConfigData(NodeID dest, int commands, int options, int highSpace, int lowSpace, String name) {
        }
    }

    @Immutable
    @ThreadSafe
    public class WriteStreamMemo
    extends DatagramService.DatagramServiceTransmitMemo {
        McsWriteStreamMemo memo;

        public WriteStreamMemo(NodeID dest, int space, long address, int srcStreamId, McsWriteStreamMemo memo) {
            super(dest);
            boolean spaceByte = false;
            if (space < 253) {
                spaceByte = true;
            }
            this.data = new int[6 + (spaceByte ? 1 : 0) + 1];
            this.data[0] = 32;
            this.data[1] = 32;
            if (space >= 253) {
                this.data[1] = this.data[1] | space & 3;
            }
            this.data[2] = (int)(address >> 24) & 0xFF;
            this.data[3] = (int)(address >> 16) & 0xFF;
            this.data[4] = (int)(address >> 8) & 0xFF;
            this.data[5] = (int)address & 0xFF;
            int ofs = 6;
            if (spaceByte) {
                this.data[ofs++] = space;
            }
            if (srcStreamId < 1 || srcStreamId > 254) {
                throw new IllegalArgumentException("Invalid source stream ID: " + srcStreamId);
            }
            this.data[ofs++] = srcStreamId;
            this.memo = memo;
        }

        @Override
        public void handleSuccess(int flags) {
            if (0 != (flags & 0x80)) {
                return;
            }
            MemoryConfigurationService.this.writeStreamMemo = null;
            this.memo.handleSuccess();
        }

        @Override
        public void handleFailure(int errorCode) {
            MemoryConfigurationService.this.writeStreamMemo = null;
            this.memo.handleFailure("TxDatagram", errorCode);
        }
    }

    @Immutable
    @ThreadSafe
    public static abstract class McsWriteStreamMemo {
        final long address;
        final int space;
        final NodeID dest;
        final int srcStreamId;

        public McsWriteStreamMemo(NodeID dest, int space, long address, int srcStreamId) {
            this.address = address;
            this.space = space;
            this.dest = dest;
            this.srcStreamId = srcStreamId;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof McsWriteStreamMemo)) {
                return false;
            }
            McsWriteStreamMemo m = (McsWriteStreamMemo)o;
            if (this.dest != m.dest) {
                return false;
            }
            if (this.space != m.space) {
                return false;
            }
            if (this.address != m.address) {
                return false;
            }
            return this.srcStreamId == m.srcStreamId;
        }

        public String toString() {
            return "McsWriteStreamMemo: " + this.address;
        }

        public int hashCode() {
            return this.dest.hashCode() + this.space + (int)this.address;
        }

        public abstract void handleSuccess();

        public abstract void handleFailure(String var1, int var2);
    }

    static class McsReadMemo
    extends McsAddressedRequestMemo
    implements RequestWithReplyDatagram {
        final int len;
        final McsReadHandler callback;

        public McsReadMemo(NodeID dest, int space, long address, int len, McsReadHandler cb) {
            super(dest, 64, space, address, cb);
            this.len = len;
            this.callback = cb;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (!(o instanceof McsReadMemo)) {
                return false;
            }
            McsReadMemo m = (McsReadMemo)o;
            return this.len == m.len;
        }

        @Override
        protected int getPayloadLength() {
            return 1;
        }

        @Override
        protected void fillPayload(int[] data) {
            data[this.getPayloadOffset()] = this.len;
        }

        @Override
        protected void handleSuccessResponse(int[] data) {
            int payofs = this.getPayloadOffset(data);
            byte[] response = new byte[data.length - payofs];
            DatagramUtils.intToByteArray(response, 0, data, payofs, response.length);
            this.callback.handleReadData(this.dest, this.space, this.address, response);
        }
    }

    public static interface McsReadHandler
    extends FailureCallback {
        public void handleReadData(NodeID var1, int var2, long var3, byte[] var5);
    }

    public static interface McsWriteHandler
    extends NoReturnCallback {
    }

    static class McsWriteMemo
    extends McsAddressedRequestMemo
    implements RequestWithNoReply {
        final byte[] data;
        final NoReturnCallback callback;

        public McsWriteMemo(NodeID dest, int space, long address, byte[] data, NoReturnCallback cb) {
            super(dest, 0, space, address, cb);
            this.data = data;
            this.callback = cb;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (!(o instanceof McsWriteMemo)) {
                return false;
            }
            McsWriteMemo m = (McsWriteMemo)o;
            if (this.data.length != m.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == m.data[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int getPayloadLength() {
            return this.data.length;
        }

        @Override
        protected void fillPayload(int[] data) {
            for (int i = 0; i < this.data.length; ++i) {
                data[this.getPayloadOffset() + i] = DatagramUtils.byteToInt(this.data[i]);
            }
        }

        @Override
        protected void handleSuccessResponse(int[] data) {
            this.callback.handleSuccess();
        }

        @Override
        public NoReturnCallback getNoReturnCallback() {
            return this.callback;
        }
    }

    private static abstract class McsAddressedRequestMemo
    extends McsRequestMemo
    implements RequestWithReplyDatagram {
        protected final int space;
        protected final long address;

        McsAddressedRequestMemo(NodeID dest, int requestCode, int space, long address, FailureCallback cb) {
            super(dest, requestCode, cb);
            this.space = space;
            this.address = address;
        }

        protected int getSpaceOffset() {
            return this.space >= 253 ? 0 : 1;
        }

        protected int getPayloadOffset() {
            return 6 + this.getSpaceOffset();
        }

        protected int getPayloadOffset(int[] data) {
            return 6 + ((data[1] & 3) != 0 ? 0 : 1);
        }

        protected void fillRequest(int[] data) {
            data[0] = 32;
            data[1] = this.getRequestCode();
            if (this.space >= 253) {
                data[1] = data[1] | this.space & 3;
            } else {
                data[6] = this.space & 0xFF;
            }
            DatagramUtils.renderLong(data, 2, this.address);
        }

        protected abstract int getPayloadLength();

        protected abstract void fillPayload(int[] var1);

        @Override
        protected int[] renderTransmitDatagram() {
            int[] data = new int[this.getPayloadOffset() + this.getPayloadLength()];
            this.fillRequest(data);
            this.fillPayload(data);
            return data;
        }

        @Override
        public boolean compareResponse(int[] data) {
            if (data.length < 6 + this.getSpaceOffset()) {
                return false;
            }
            if (this.address != DatagramUtils.parseLong(data, 2)) {
                return false;
            }
            return this.space == MemoryConfigurationService.getSpaceFromPayload(data);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (!(o instanceof McsAddressedRequestMemo)) {
                return false;
            }
            McsAddressedRequestMemo m = (McsAddressedRequestMemo)o;
            if (this.space != m.space) {
                return false;
            }
            return this.address == m.address;
        }

        public int hashCode() {
            return this.getRequestCode() + this.dest.hashCode() + (int)this.address + this.space;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": dest " + this.dest.toString() + " space 0x" + Integer.toHexString(this.space) + " address 0x" + Long.toHexString(this.address);
        }

        @Override
        public void handleResponseDatagram(int[] data) {
            if ((data[1] & 8) != 0) {
                this.failureCallback.handleFailure(DatagramUtils.parseErrorCode(data, this.getPayloadOffset(data)));
                return;
            }
            this.handleSuccessResponse(data);
        }

        protected abstract void handleSuccessResponse(int[] var1);
    }

    private static interface RequestWithNoReply {
        public NoReturnCallback getNoReturnCallback();
    }

    private static interface RequestWithReplyDatagram {
        public void handleResponseDatagram(int[] var1);

        public boolean compareResponse(int[] var1);
    }

    private static abstract class McsRequestMemo {
        protected final NodeID dest;
        protected final int requestCode;
        protected final FailureCallback failureCallback;
        boolean foundResponse = false;
        int numTries = 0;

        McsRequestMemo(NodeID dest, int requestCode, FailureCallback cb) {
            this.dest = dest;
            this.requestCode = requestCode;
            this.failureCallback = cb;
        }

        public int getRequestCode() {
            return this.requestCode;
        }

        protected NodeID getDest() {
            return this.dest;
        }

        public boolean equals(Object o) {
            if (!(o instanceof McsRequestMemo)) {
                return false;
            }
            McsRequestMemo m = (McsRequestMemo)o;
            if (!this.dest.equals(m.dest)) {
                return false;
            }
            return this.getRequestCode() == m.getRequestCode();
        }

        protected abstract int[] renderTransmitDatagram();
    }
}

