/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.DatagramRejectedMessage;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

public class DatagramService
extends MessageDecoder {
    private static final Logger logger = Logger.getLogger(DatagramService.class.getName());
    public static final int FLAG_REPLY_PENDING = 128;
    static final int DEFAULT_ERROR_CODE = 4096;
    NodeID here;
    Connection downstream;
    DatagramServiceReceiveMemo rcvMemo;
    DatagramServiceTransmitMemo xmtMemo;

    public DatagramService(NodeID here, Connection downstream) {
        this.here = here;
        this.downstream = downstream;
    }

    public void sendData(DatagramServiceTransmitMemo memo) {
        if (this.xmtMemo != null) {
            logger.log(Level.SEVERE, "Overriding datagram transmit memo. old {0} new {1}", new Object[]{this.xmtMemo, memo});
        }
        this.xmtMemo = memo;
        DatagramMessage m = new DatagramMessage(this.here, memo.dest, memo.data);
        this.downstream.put(m, this);
    }

    public void sendData(NodeID dest, int[] data) {
        DatagramServiceTransmitMemo memo;
        this.xmtMemo = memo = new DatagramServiceTransmitMemo(dest, data){

            @Override
            public void handleSuccess(int flags) {
            }

            @Override
            public void handleFailure(int errorCode) {
            }
        };
        DatagramMessage m = new DatagramMessage(this.here, memo.dest, memo.data);
        this.downstream.put(m, this);
    }

    @Override
    public void handleDatagram(DatagramMessage msg, Connection sender) {
        if (!msg.getDestNodeID().equals(this.here)) {
            return;
        }
        int retval = 4096;
        ReplyMemo replyMemo = new ReplyMemo(msg, this.downstream, this.here, this);
        if (msg.getData() == null) {
            new Exception("Unexpected null content of datagram").printStackTrace();
        }
        if (msg.getData() != null && msg.getData().length == 0) {
            new Exception("Unexpected zero length content of datagram").printStackTrace();
        }
        if (this.rcvMemo != null && msg.getData() != null && msg.getData().length > 0 && this.rcvMemo.type == msg.getData()[0]) {
            this.rcvMemo.handleData(msg.getSourceNodeID(), msg.getData(), replyMemo);
            if (!replyMemo.hasReplied()) {
                logger.log(Level.SEVERE, "No internal reply received to datagram with contents {0}", Utilities.toHexDotsString(msg.getData()));
            }
        } else {
            replyMemo.acceptData(retval);
        }
    }

    @Override
    public void handleDatagramRejected(DatagramRejectedMessage msg, Connection sender) {
        if (this.xmtMemo != null && msg.getDestNodeID().equals(this.here) && this.xmtMemo.dest.equals(msg.getSourceNodeID())) {
            if (msg.canResend()) {
                return;
            }
            DatagramServiceTransmitMemo temp = this.xmtMemo;
            this.xmtMemo = null;
            temp.handleFailure(msg.getCode());
        }
    }

    @Override
    public void handleDatagramAcknowledged(DatagramAcknowledgedMessage msg, Connection sender) {
        if (this.xmtMemo != null && msg.getDestNodeID().equals(this.here) && this.xmtMemo.dest.equals(msg.getSourceNodeID())) {
            DatagramServiceTransmitMemo temp = this.xmtMemo;
            this.xmtMemo = null;
            temp.handleSuccess(msg.getFlags());
        }
    }

    public void registerForReceive(DatagramServiceReceiveMemo memo) {
        this.rcvMemo = memo;
    }

    @Immutable
    @ThreadSafe
    public static abstract class DatagramServiceTransmitMemo {
        protected int[] data;
        final NodeID dest;

        public DatagramServiceTransmitMemo(NodeID dest, int[] data) {
            this.data = data;
            this.dest = dest;
        }

        protected DatagramServiceTransmitMemo(NodeID dest) {
            this.data = null;
            this.dest = dest;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DatagramServiceTransmitMemo)) {
                return false;
            }
            DatagramServiceTransmitMemo m = (DatagramServiceTransmitMemo)o;
            if (this.data.length != m.data.length) {
                return false;
            }
            if (this.dest != m.dest) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == m.data[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "DatagramServiceTransmitMemo to " + this.dest.toString() + ": " + Utilities.toHexDotsString(this.data);
        }

        public int hashCode() {
            return this.data.length + this.data[0] + this.dest.hashCode();
        }

        public abstract void handleSuccess(int var1);

        public abstract void handleFailure(int var1);
    }

    @Immutable
    protected static class ReplyMemo {
        DatagramMessage msg;
        Connection downstream;
        NodeID here;
        DatagramService service;
        boolean replied = false;

        protected ReplyMemo(DatagramMessage msg, Connection downstream, NodeID here, DatagramService service) {
            this.msg = msg;
            this.downstream = downstream;
            this.here = here;
            this.service = service;
        }

        public void acceptData(int resultCode) {
            this.replied = true;
            if (resultCode == 0) {
                DatagramAcknowledgedMessage m = new DatagramAcknowledgedMessage(this.here, this.msg.getSourceNodeID());
                this.downstream.put(m, this.service);
            } else {
                DatagramRejectedMessage m = new DatagramRejectedMessage(this.here, this.msg.getSourceNodeID(), resultCode);
                this.downstream.put(m, this.service);
            }
        }

        boolean hasReplied() {
            return this.replied;
        }
    }

    @Immutable
    @ThreadSafe
    protected static class DatagramServiceReceiveMemo {
        final int type;

        public DatagramServiceReceiveMemo(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DatagramServiceReceiveMemo)) {
                return false;
            }
            return this.type == ((DatagramServiceReceiveMemo)o).type;
        }

        public String toString() {
            return "DatagramServiceReceiveMemo: " + this.type;
        }

        public int hashCode() {
            return this.type;
        }

        public void acceptData(int resultCode) {
        }

        public void handleData(NodeID n, int[] data, ReplyMemo service) {
            service.acceptData(4096);
        }
    }
}

