/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.AbstractConnection;
import org.openlcb.Connection;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.DatagramRejectedMessage;
import org.openlcb.InitializationCompleteMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.OlcbThreadFactory;

public class DatagramMeteringBuffer
extends MessageDecoder {
    static final int TIMEOUT = 3000;
    private static final Logger logger = Logger.getLogger(DatagramMeteringBuffer.class.getName());
    private ThreadPoolExecutor threadPool = null;
    static final int minThreads = 10;
    static final int maxThreads = 10;
    static final long threadTimeout = 10L;
    Connection toDownstream;
    Connection fromDownstream;
    MessageMemo currentMemo;
    private Timer timer = null;
    int timeoutMillis = 3000;
    BlockingQueue<MessageMemo> queue = new LinkedBlockingQueue<MessageMemo>();
    int pendingEntries = 0;
    int threadPending = 0;

    @Deprecated
    public DatagramMeteringBuffer(Connection toDownstream) {
        this(toDownstream, new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new OlcbThreadFactory()));
    }

    public DatagramMeteringBuffer(Connection toDownstream, ThreadPoolExecutor tpe) {
        this.threadPool = tpe;
        if (this.timer == null) {
            this.timer = new Timer("OpenLCB-datagram-timer");
        }
        this.toDownstream = toDownstream;
        this.datagramComplete();
        this.fromDownstream = new ReplyHandler();
    }

    public Connection connectionForRepliesFromDownstream() {
        return this.fromDownstream;
    }

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSendQueue() {
        while (true) {
            DatagramMeteringBuffer datagramMeteringBuffer = this;
            synchronized (datagramMeteringBuffer) {
                if (this.pendingEntries == 0 || this.threadPending == 0) {
                    break;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.waitForTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSendCallbacks() throws InterruptedException {
        while (true) {
            DatagramMeteringBuffer datagramMeteringBuffer = this;
            synchronized (datagramMeteringBuffer) {
                if (this.pendingEntries == 0 && this.threadPending == 1) {
                    break;
                }
            }
            Thread.sleep(10L);
        }
        this.waitForTimer();
    }

    private void waitForTimer() {
        final Semaphore s = new Semaphore(0);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                s.release();
            }
        }, 1L);
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Message msg, Connection toUpstream) {
        if (msg instanceof DatagramMessage) {
            DatagramMeteringBuffer datagramMeteringBuffer = this;
            synchronized (datagramMeteringBuffer) {
                ++this.pendingEntries;
            }
            this.queue.add(new MessageMemo((DatagramMessage)msg, toUpstream, this.toDownstream));
        } else {
            this.toDownstream.put(msg, this.fromDownstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void datagramComplete() {
        this.currentMemo = null;
        DatagramMeteringBuffer datagramMeteringBuffer = this;
        synchronized (datagramMeteringBuffer) {
            ++this.threadPending;
        }
        this.threadPool.execute(new Consumer(this.queue));
    }

    public void dispose() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                    this.threadPool.shutdownNow();
                    if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                        logger.warning("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.threadPool = null;
        this.timer.cancel();
        this.timer = null;
    }

    class Consumer
    implements Runnable {
        private final BlockingQueue<MessageMemo> queue;

        Consumer(BlockingQueue<MessageMemo> q) {
            this.queue = q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DatagramMeteringBuffer datagramMeteringBuffer;
            if (DatagramMeteringBuffer.this.threadPool == null || DatagramMeteringBuffer.this.threadPool.isShutdown()) {
                return;
            }
            try {
                this.consume(this.queue.take());
                datagramMeteringBuffer = DatagramMeteringBuffer.this;
                synchronized (datagramMeteringBuffer) {
                    --DatagramMeteringBuffer.this.pendingEntries;
                }
            }
            catch (InterruptedException interruptedException) {
                DatagramMeteringBuffer datagramMeteringBuffer2 = DatagramMeteringBuffer.this;
                synchronized (datagramMeteringBuffer2) {
                    --DatagramMeteringBuffer.this.threadPending;
                }
            }
            finally {
                datagramMeteringBuffer = DatagramMeteringBuffer.this;
                synchronized (datagramMeteringBuffer) {
                    --DatagramMeteringBuffer.this.threadPending;
                }
            }
        }

        void consume(MessageMemo x) {
            x.sendIt();
        }
    }

    class MessageMemo
    extends MessageDecoder {
        DatagramMessage message;
        Connection toDownstream;
        Connection toUpstream;
        TimerTask timerTask;

        MessageMemo(DatagramMessage msg, Connection toUpstream, Connection toDownstream) {
            this.message = msg;
            this.toUpstream = toUpstream;
            this.toDownstream = toDownstream;
        }

        public void sendIt() {
            DatagramMeteringBuffer.this.currentMemo = this;
            this.forwardDownstream();
        }

        void forwardDownstream() {
            this.startTimeout();
            this.toDownstream.put(this.message, DatagramMeteringBuffer.this.fromDownstream);
        }

        void startTimeout() {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    MessageMemo.this.timerExpired();
                }
            };
            try {
                DatagramMeteringBuffer.this.timer.schedule(this.timerTask, DatagramMeteringBuffer.this.timeoutMillis);
            }
            catch (IllegalStateException ise) {
                logger.log(Level.WARNING, "Timer already canceled when starting timeout for datagram {0}", this.message != null ? this.message : " == null");
            }
            catch (RejectedExecutionException ree) {
                logger.log(Level.WARNING, "Timer rejected execution when starting timeout for datagram {0}", this.message != null ? this.message : " == null");
            }
        }

        void endTimeout() {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            } else {
                logger.log(Level.INFO, "Found timer null for datagram {0}", this.message != null ? this.message : " == null");
            }
        }

        void timerExpired() {
            DatagramRejectedMessage msg = new DatagramRejectedMessage(this.message.getDestNodeID(), this.message.getSourceNodeID(), 256);
            logger.log(Level.INFO, "Never received reply for datagram {0}", this.message);
            this.handleDatagramRejected(msg, null);
            this.toUpstream.put(msg, this.toUpstream);
        }

        @Override
        public void handleInitializationComplete(InitializationCompleteMessage msg, Connection sender) {
            if (msg.getSourceNodeID() != null && msg.getSourceNodeID().equals(this.message.getDestNodeID())) {
                DatagramRejectedMessage rejectedMessage = new DatagramRejectedMessage(this.message.getDestNodeID(), this.message.getSourceNodeID(), 65792);
                logger.log(Level.INFO, "Destination node has rebooted while waiting for datagram reply {0}", this.message);
                this.handleDatagramRejected(rejectedMessage, null);
                this.toUpstream.put(rejectedMessage, this.toUpstream);
            }
        }

        @Override
        public void handleDatagramAcknowledged(DatagramAcknowledgedMessage msg, Connection sender) {
            if (msg.getDestNodeID() == null || msg.getSourceNodeID() == null || !msg.getDestNodeID().equals(this.message.getSourceNodeID()) || !this.message.getDestNodeID().equals(msg.getSourceNodeID())) {
                return;
            }
            this.endTimeout();
            DatagramMeteringBuffer.this.datagramComplete();
        }

        @Override
        public void handleDatagramRejected(DatagramRejectedMessage msg, Connection sender) {
            if (msg.getDestNodeID() == null || msg.getSourceNodeID() == null || !msg.getDestNodeID().equals(this.message.getSourceNodeID()) || !this.message.getDestNodeID().equals(msg.getSourceNodeID())) {
                return;
            }
            this.endTimeout();
            if (msg.canResend()) {
                this.forwardDownstream();
            } else {
                DatagramMeteringBuffer.this.datagramComplete();
            }
        }
    }

    class ReplyHandler
    extends AbstractConnection {
        ReplyHandler() {
        }

        @Override
        public void put(Message msg, Connection sender) {
            if (DatagramMeteringBuffer.this.currentMemo == null) {
                return;
            }
            DatagramMeteringBuffer.this.currentMemo.put(msg, sender);
        }
    }
}

