/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.LearnEventMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.implementations.ScatterGather;
import org.openlcb.implementations.SingleConsumer;
import org.openlcb.implementations.SingleProducer;

public class BlueGoldEngine
extends MessageDecoder
implements Connection {
    int selectedPC = -1;
    private static final Logger logger = Logger.getLogger(BlueGoldEngine.class.getName());
    NodeID nid;
    ScatterGather sg;
    Connection c;
    List<SingleProducer> producers;
    List<SingleConsumer> consumers;

    public void goldClick() {
        if (this.selectedPC >= 0) {
            this.sendLearnEventMessage(this.getEventID(this.selectedPC));
            this.setGoldLightOn(false);
            this.setBlueLightOn(false);
            this.selectedPC = -1;
            logger.info("send learn event");
            return;
        }
    }

    public void longGoldPress() {
    }

    public void blueClick() {
        ++this.selectedPC;
        this.setBlueLightOn(true);
        if (this.selectedPC >= this.producers.size() + this.consumers.size()) {
            this.selectedPC = -1;
            this.setBlueLightOn(false);
        } else {
            this.setBlueLightOn(true);
        }
        logger.log(Level.INFO, "incremented selectedPC to {0}", this.selectedPC);
    }

    public void longBluePress() {
    }

    @Override
    public void handleLearnEvent(LearnEventMessage msg, Connection sender) {
        if (this.selectedPC >= 0) {
            EventID eid = msg.getEventID();
            logger.log(Level.INFO, "Set {0} to {1}", new Object[]{this.selectedPC, eid});
            this.setEventID(this.selectedPC, eid);
        }
        this.setBlueLightOn(false);
        this.setGoldLightOn(false);
        this.selectedPC = -1;
    }

    public void setBlueLightOn(boolean f) {
    }

    public boolean getBlueLightOn() {
        return false;
    }

    public void setBlueLightBlink(int dwell) {
    }

    public void setGoldLightOn(boolean f) {
    }

    public boolean getGoldLightOn() {
        return false;
    }

    public void setGoldLightBlink(int dwell) {
    }

    public BlueGoldEngine(NodeID nid, ScatterGather sg, List<SingleProducer> producers, List<SingleConsumer> consumers) {
        this.nid = nid;
        this.sg = sg;
        this.c = sg.getConnection();
        this.consumers = consumers;
        this.producers = producers;
        sg.register(this);
    }

    @Override
    public void put(Message msg, Connection sender) {
        msg.applyTo(this, sender);
    }

    protected void sendLearnEventMessage(EventID eid) {
        LearnEventMessage msg = new LearnEventMessage(this.nid, eid);
        this.c.put(msg, this);
        this.handleLearnEvent(msg, null);
    }

    EventID getEventID(int n) {
        if (n < this.producers.size()) {
            return this.producers.get(n).getEventID();
        }
        return this.consumers.get(n - this.consumers.size()).getEventID();
    }

    void setEventID(int n, EventID eid) {
        if (n < 0) {
            return;
        }
        if (n < this.producers.size()) {
            this.producers.get(n).setEventID(eid);
        } else {
            this.consumers.get(n - this.consumers.size()).setEventID(eid);
        }
    }
}

