/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.EventState;
import org.openlcb.IdentifyConsumersMessage;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.IdentifyEventsGlobalMessage;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.MessageDecoder;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.implementations.VersionedValue;
import org.openlcb.implementations.VersionedValueListener;

public class BitProducerConsumer
extends MessageDecoder {
    private final EventID eventOn;
    private final EventID eventOff;
    private final OlcbInterface iface;
    private final VersionedValue<Boolean> value;
    private final VersionedValueListener<Boolean> valueListener;
    private final int flags;
    public static final EventID nullEvent = new EventID(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
    public static final int DEFAULT_TRUE = 1;
    public static final int IS_PRODUCER = 2;
    public static final int IS_CONSUMER = 4;
    public static final int QUERY_AT_STARTUP = 8;
    public static final int LISTEN_EVENT_IDENTIFIED = 16;
    public static final int SEND_UNKNOWN_EVENT_IDENTIFIED = 32;
    public static final int LISTEN_INVALID_STATE = 64;
    public static final int DEFAULT_FLAGS = 94;

    public BitProducerConsumer(OlcbInterface iface, EventID eventOn, EventID eventOff) {
        this(iface, eventOn, eventOff, 94);
    }

    public BitProducerConsumer(OlcbInterface iface, EventID eventOn, EventID eventOff, boolean defaultValue) {
        this(iface, eventOn, eventOff, 0x5E | (defaultValue ? 1 : 0));
    }

    public BitProducerConsumer(OlcbInterface iface, EventID eventOn, EventID eventOff, final int flags) {
        this.iface = iface;
        this.eventOn = eventOn;
        this.eventOff = eventOff;
        this.flags = flags;
        this.value = new VersionedValue<Boolean>((flags & 1) != 0);
        this.valueListener = new VersionedValueListener<Boolean>(this.value){

            @Override
            public void update(Boolean newValue) {
                if ((flags & 2) == 0) {
                    return;
                }
                EventID id = newValue != false ? BitProducerConsumer.this.eventOn : BitProducerConsumer.this.eventOff;
                BitProducerConsumer.this.sendMessage(new ProducerConsumerEventReportMessage(BitProducerConsumer.this.iface.getNodeId(), id));
            }
        };
        iface.registerMessageListener(this);
        iface.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                BitProducerConsumer.this.sendIdentifiedMessages((flags & 8) != 0);
            }
        });
    }

    public VersionedValue<Boolean> getValue() {
        return this.value;
    }

    public void resetToDefault() {
        this.value.setVersionToDefault();
    }

    public void sendQuery() {
        this.sendMessage(new IdentifyProducersMessage(this.iface.getNodeId(), this.eventOff));
        this.sendMessage(new IdentifyConsumersMessage(this.iface.getNodeId(), this.eventOff));
        this.sendMessage(new IdentifyProducersMessage(this.iface.getNodeId(), this.eventOn));
        this.sendMessage(new IdentifyConsumersMessage(this.iface.getNodeId(), this.eventOn));
    }

    <T extends EventMessage> void sendMessage(T msg) {
        if (msg.getEventID().equals(nullEvent)) {
            return;
        }
        this.iface.getOutputConnection().put(msg, this);
    }

    public boolean isValueAtDefault() {
        return this.value.isVersionAtDefault();
    }

    private EventState getOnEventState() {
        if (this.isValueAtDefault() || (this.flags & 0x20) > 0) {
            return EventState.Unknown;
        }
        if (this.value.getLatestData().booleanValue()) {
            return EventState.Valid;
        }
        return EventState.Invalid;
    }

    private EventState getOffEventState() {
        return this.getOnEventState().inverted();
    }

    private EventState getEventState(EventID event) {
        if (event.equals(this.eventOn)) {
            return this.getOnEventState();
        }
        if (event.equals(this.eventOff)) {
            return this.getOffEventState();
        }
        return null;
    }

    private void sendIdentifiedMessages(boolean queryState) {
        if ((this.flags & 2) != 0) {
            this.sendMessage(new ProducerIdentifiedMessage(this.iface.getNodeId(), this.eventOn, this.getOnEventState()));
            this.sendMessage(new ProducerIdentifiedMessage(this.iface.getNodeId(), this.eventOff, this.getOffEventState()));
        }
        if ((this.flags & 4) != 0) {
            this.sendMessage(new ConsumerIdentifiedMessage(this.iface.getNodeId(), this.eventOn, this.getOnEventState()));
            this.sendMessage(new ConsumerIdentifiedMessage(this.iface.getNodeId(), this.eventOff, this.getOffEventState()));
        }
        if (queryState) {
            this.sendQuery();
        }
    }

    public void release() {
        this.iface.unRegisterMessageListener(this);
    }

    @Override
    public void handleIdentifyConsumers(IdentifyConsumersMessage msg, Connection sender) {
        if (sender == this) {
            return;
        }
        EventState st = this.getEventState(msg.getEventID());
        if (st != null && (this.flags & 4) != 0) {
            this.sendMessage(new ConsumerIdentifiedMessage(this.iface.getNodeId(), msg.getEventID(), st));
        }
    }

    @Override
    public void handleIdentifyProducers(IdentifyProducersMessage msg, Connection sender) {
        if (sender == this) {
            return;
        }
        EventState st = this.getEventState(msg.getEventID());
        if (st != null && (this.flags & 2) != 0) {
            this.sendMessage(new ProducerIdentifiedMessage(this.iface.getNodeId(), msg.getEventID(), st));
        }
    }

    private boolean shouldListenToIdentifiedMessages() {
        if ((this.flags & 0x10) != 0) {
            return true;
        }
        return (this.flags & 8) != 0 && this.isValueAtDefault();
    }

    @Override
    public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
        boolean isOn;
        if (!this.shouldListenToIdentifiedMessages()) {
            return;
        }
        if (msg.getEventID().equals(this.eventOn)) {
            isOn = true;
        } else if (msg.getEventID().equals(this.eventOff)) {
            isOn = false;
        } else {
            return;
        }
        if (msg.getEventState().equals((Object)EventState.Valid)) {
            this.setValueFromNetwork(isOn);
        } else if (msg.getEventState().equals((Object)EventState.Invalid) && (this.flags & 0x40) != 0) {
            this.setValueFromNetwork(!isOn);
        }
    }

    @Override
    public void handleConsumerIdentified(ConsumerIdentifiedMessage msg, Connection sender) {
        boolean isOn;
        if (!this.shouldListenToIdentifiedMessages()) {
            return;
        }
        if (msg.getEventID().equals(this.eventOn)) {
            isOn = true;
        } else if (msg.getEventID().equals(this.eventOff)) {
            isOn = false;
        } else {
            return;
        }
        if (msg.getEventState().equals((Object)EventState.Valid)) {
            this.setValueFromNetwork(isOn);
        } else if (msg.getEventState().equals((Object)EventState.Invalid) && (this.flags & 0x40) != 0) {
            this.setValueFromNetwork(!isOn);
        }
    }

    @Override
    public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
        boolean isOn;
        if ((this.flags & 4) == 0) {
            return;
        }
        if (msg.getEventID().equals(this.eventOn)) {
            isOn = true;
        } else if (msg.getEventID().equals(this.eventOff)) {
            isOn = false;
        } else {
            return;
        }
        this.setValueFromNetwork(isOn);
    }

    @Override
    public void handleIdentifyEventsAddressed(IdentifyEventsAddressedMessage msg, Connection sender) {
        if (msg.getDestNodeID().equals(this.iface.getNodeId())) {
            this.sendIdentifiedMessages(false);
        }
    }

    @Override
    public void handleIdentifyEventsGlobal(IdentifyEventsGlobalMessage msg, Connection sender) {
        this.sendIdentifiedMessages(false);
    }

    private void setValueFromNetwork(boolean isOn) {
        this.valueListener.setFromOwner(isOn);
    }
}

