/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.hub;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Hub {
    private static final Logger logger = Logger.getLogger(Hub.class.getName());
    public static final int DEFAULT_PORT = 12021;
    static final int CAPACITY = 20;
    BlockingQueue<Memo> queue = new LinkedBlockingQueue<Memo>();
    ArrayList<Forwarding> threads = new ArrayList();
    int port;
    ServerSocket service;

    public Hub() {
        this(12021);
    }

    public Hub(int port) {
        this.port = port;
        Thread t = new Thread("openlcb-hub-output"){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        Memo m = Hub.this.queue.take();
                        Iterator<Forwarding> iterator = Hub.this.threads.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            Forwarding e = iterator.next();
                            e.forward(m);
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    logger.severe("Hub: Interrupted in queue handling loop");
                    logger.log(Level.SEVERE, "", e);
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void start() {
        try {
            this.service = new ServerSocket(this.port);
            while (true) {
                Socket clientSocket = this.service.accept();
                ReaderThread r = new ReaderThread(clientSocket);
                this.addForwarder(r);
                r.start();
                this.notifyOwner("Connection started with " + this.getRemoteSocketAddress(clientSocket));
            }
        }
        catch (IOException e) {
            logger.severe("Hub: Exception in main loop");
            logger.log(Level.SEVERE, "", e);
            return;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void addForwarder(Forwarding f) {
        this.threads.add(f);
    }

    public void notifyOwner(String line) {
        logger.info(line);
    }

    String getRemoteSocketAddress(Socket socket) {
        try {
            String string = socket.getRemoteSocketAddress().toString();
            return string;
        }
        catch (Throwable throwable) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return "<unknown>";
    }

    public void putLine(String line) {
        try {
            this.queue.put(new Memo(line, null));
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public static void main(String[] args) {
        Hub h = new Hub();
        h.start();
    }

    public class Memo {
        public String line;
        public Forwarding source;

        Memo(String line, Forwarding source) {
            this.line = line;
            this.source = source;
        }
    }

    class ReaderThread
    extends Thread
    implements Forwarding {
        Socket clientSocket;
        DataInputStream input;
        PrintStream output;

        ReaderThread(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        @Override
        public void run() {
            try {
                String line;
                this.input = new DataInputStream(this.clientSocket.getInputStream());
                this.output = new PrintStream(this.clientSocket.getOutputStream(), true, "ISO-8859-1");
                while ((line = this.input.readLine()) != null) {
                    Hub.this.queue.put(new Memo(line, this));
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Hub: Error while handling input from {0}", Hub.this.getRemoteSocketAddress(this.clientSocket));
                logger.log(Level.SEVERE, "", e);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Hub: Interrupted while handling input from {0}", Hub.this.getRemoteSocketAddress(this.clientSocket));
                logger.log(Level.SEVERE, "", e);
            }
            Hub.this.threads.remove(this);
            Hub.this.notifyOwner("Connection ended with " + Hub.this.getRemoteSocketAddress(this.clientSocket));
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                logger.severe("Hub: Error while closing socket at end of connection");
                logger.log(Level.SEVERE, "", e);
            }
        }

        @Override
        public void forward(Memo m) {
            if (!this.equals(m.source)) {
                this.output.println(m.line);
            }
        }
    }

    public static interface Forwarding {
        public void forward(Memo var1);
    }
}

