/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.swing;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openlcb.EventID;
import org.openlcb.Utilities;
import org.openlcb.cdi.CdiRep;
import org.openlcb.cdi.cmd.BackupConfig;
import org.openlcb.cdi.cmd.RestoreConfig;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.openlcb.swing.EventIdTextField;
import util.CollapsiblePanel;
import util.javaworld.GridLayout2;

public class CdiPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(CdiPanel.class.getName());
    private static final Color COLOR_EDITED = new Color(16765568);
    private static final Color COLOR_UNFILLED = new Color(0xFFFF00);
    private static final Color COLOR_WRITTEN = new Color(0xFFFFFF);
    private static final Color COLOR_ERROR = new Color(0xFF0000);
    private static final Pattern segmentPrefixRe = Pattern.compile("^seg[0-9]*[.]");
    private static final Pattern entrySuffixRe = Pattern.compile("[.]child[0-9]*$");
    private static final Color COLOR_COPIED = COLOR_EDITED;
    static JFileChooser fci = new JFileChooser();
    private ConfigRepresentation rep;
    private EventTable eventTable = null;
    private String nodeName = "";
    private boolean _changeMade = false;
    private boolean _unsavedRestore = false;
    private boolean _panelChange = false;
    private JButton _saveButton;
    private Color COLOR_DEFAULT;
    private List<CollapsiblePanel> segmentPanels = new ArrayList<CollapsiblePanel>();
    private final Color COLOR_BACKGROUND;
    GuiItemFactory factory;
    JPanel loadingPanel;
    JLabel loadingText;
    PropertyChangeListener loadingListener;
    private JButton reloadButton;
    private final List<EntryPane> allEntries = new ArrayList<EntryPane>();
    private final Map<String, EntryPane> entriesByKey = new HashMap<String, EntryPane>();
    private final Map<String, JTabbedPane> tabsByKey = new HashMap<String, JTabbedPane>();
    private final ArrayList<Runnable> cleanupTasks = new ArrayList();
    private final ArrayList<Runnable> startupTasks = new ArrayList();
    private boolean renderingInProgress = true;
    boolean loadingIsPacked = false;
    JScrollPane scrollPane;
    JPanel contentPanel;
    JPanel buttonBar;
    JPopupMenu moreMenu = new JPopupMenu();
    JButton moreButton;
    SearchPane searchPane = new SearchPane();
    private java.util.Timer tabColorTimer;
    long lastColorRefreshNeeded = 0L;
    long lastColorRefreshDone = Long.MAX_VALUE;

    public CdiPanel() {
        this.tabColorTimer = new java.util.Timer("OpenLCB CDI Reader Tab Color Timer");
        this.COLOR_BACKGROUND = this.getBackground().darker();
        this.setForeground(this.COLOR_BACKGROUND);
    }

    public CdiPanel(File dir) {
        this();
        fci.setCurrentDirectory(dir);
    }

    public void release() {
        logger.log(Level.FINE, "Cleanup of CDI window for {0}", this.nodeName);
        for (Runnable task : this.cleanupTasks) {
            task.run();
        }
        this.cleanupTasks.clear();
        this.tabColorTimer.cancel();
    }

    public void setEventTable(String nodeName, EventTable t) {
        this.eventTable = t;
        this.nodeName = nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponents(ConfigRepresentation rep, GuiItemFactory factory) {
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.rep = rep;
        this.factory = factory;
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.setAlignmentX(0.0f);
        this.contentPanel.setBackground(this.COLOR_BACKGROUND);
        this.scrollPane = new JScrollPane(this.contentPanel);
        Dimension minScrollerDim = new Dimension(800, 12);
        this.scrollPane.setMinimumSize(minScrollerDim);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add(this.scrollPane);
        this.buttonBar = new JPanel();
        this.buttonBar.setLayout(new FlowLayout());
        JButton bb = new JButton("Refresh All");
        bb.setToolTipText("Discards all changes and loads the freshest value from the hardware for all entries.");
        bb.addActionListener(actionEvent -> this.reloadAll());
        this.buttonBar.add(bb);
        this._saveButton = new JButton("Save Changes");
        this.COLOR_DEFAULT = this._saveButton.getBackground();
        this._saveButton.setToolTipText("Writes every changed value to the hardware.");
        this._saveButton.addActionListener(actionEvent -> this.saveChanged());
        this.buttonBar.add(this._saveButton);
        bb = new JButton("Backup...");
        bb.setToolTipText("Creates a file on your computer with all saved settings from this node. Use the \"Save Changes\" button first.");
        bb.addActionListener(actionEvent -> this.runBackup());
        this.buttonBar.add(bb);
        bb = new JButton("Restore...");
        bb.setToolTipText("Loads a file with backed-up settings. Does not change the hardware settings, so use \"Save Changes\" afterwards.");
        bb.addActionListener(actionEvent -> this.runRestore());
        this.buttonBar.add(bb);
        if (rep.getConnection() != null && rep.getRemoteNodeID() != null) {
            bb = new JButton("Reboot");
            bb.setToolTipText("Requests the configured node to restart.");
            bb.addActionListener(actionEvent -> this.runReboot());
            this.addButtonToMoreFunctions(bb);
            bb = new JButton("Update Complete");
            bb.setToolTipText("Tells the configured node that the you are done with changing the settings and they should be taking effect now. Might restart the node.");
            bb.addActionListener(actionEvent -> this.runUpdateComplete());
            this.addButtonToMoreFunctions(bb);
        }
        this.createSensorCreateHelper();
        this.buttonBar.setMaximumSize(this.buttonBar.getMinimumSize());
        this.add(this.buttonBar);
        this._changeMade = false;
        this.setSaveClean();
        ConfigRepresentation configRepresentation = rep;
        synchronized (configRepresentation) {
            if (rep.getRoot() != null) {
                this.displayCdi();
            } else {
                this.displayLoadingProgress();
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CdiPanel.this.updateWidth();
                super.componentResized(componentEvent);
            }
        });
    }

    private void createSensorCreateHelper() {
        JPanel createHelper = new JPanel();
        this.factory.handleGroupPaneStart(createHelper);
        createHelper.setAlignmentX(0.0f);
        createHelper.setLayout(new BoxLayout(createHelper, 1));
        JPanel lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("User name"));
        JTextField textField = new JTextField(32){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.factory.handleStringValue(textField);
        lineHelper.add(textField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("Event Id for Active / Thrown"));
        JFormattedTextField activeTextField = this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
        activeTextField.setMaximumSize(activeTextField.getPreferredSize());
        lineHelper.add(activeTextField);
        this.addCopyPasteButtons(lineHelper, activeTextField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("Event Id for Inactive / Closed"));
        JFormattedTextField inactiveTextField = this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
        inactiveTextField.setMaximumSize(inactiveTextField.getPreferredSize());
        lineHelper.add(inactiveTextField);
        this.addCopyPasteButtons(lineHelper, inactiveTextField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        this.factory.handleGroupPaneEnd(createHelper);
        CollapsiblePanel cp = new CollapsiblePanel("Sensor/Turnout creation", createHelper);
        cp.setBackground(this.getForeground());
        cp.setExpanded(false);
        cp.setBorder(BorderFactory.createMatteBorder(10, 0, 10, 0, this.getForeground()));
        this.add(cp);
    }

    public void initComponents(ConfigRepresentation rep) {
        this.initComponents(rep, new GuiItemFactory());
    }

    public void addButtonToFooter(JComponent c) {
        if (c instanceof JButton) {
            this.addButtonToMoreFunctions((JButton)c);
        } else {
            this.buttonBar.add(c);
        }
    }

    private void addButtonToMoreFunctions(final JButton b) {
        if (this.moreButton == null) {
            this.moreButton = new JButton("More...");
            this.moreButton.setToolTipText("Shows additional operations you can do here.");
            this.moreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CdiPanel.this.showMoreFunctionsMenu();
                }
            });
            this.buttonBar.add(this.moreButton);
        }
        AbstractAction a = new AbstractAction(b.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                b.doClick();
            }
        };
        this.moreMenu.add(a);
    }

    private void showMoreFunctionsMenu() {
        this.moreMenu.show(this.moreButton, 0, this.moreButton.getHeight());
    }

    public void reloadAll() {
        this.rep.reloadAll();
    }

    private void saveChanged() {
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDirty()) continue;
            entry.writeDisplayTextToNode();
        }
        this.checkForSave();
    }

    private void checkForSave() {
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDirty()) continue;
            this.setSaveDirty();
            return;
        }
        this._unsavedRestore = false;
        this.setSaveClean();
    }

    public void madeSensor(String uName) {
        this._panelChange = true;
    }

    public void madeTurnout(String uName) {
        this._panelChange = true;
    }

    public void runBackup() {
        int confirm;
        fci.setDialogTitle("Save configuration backup file");
        fci.rescanCurrentDirectory();
        fci.setSelectedFile(new File("config." + this.rep.getRemoteNodeAsString() + ".txt"));
        int retVal = fci.showSaveDialog(null);
        if (retVal != 0 || fci.getSelectedFile() == null) {
            return;
        }
        if (fci.getSelectedFile().exists() && (confirm = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the existing file?", "File already exists", 0, 2)) != 0) {
            return;
        }
        try {
            BackupConfig.writeConfigToFile(fci.getSelectedFile().getPath(), this.rep);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.severe("Failed to write variables to file " + fci.getSelectedFile().getPath() + ": " + e.toString());
        }
    }

    public void runRestore() {
        fci.setDialogTitle("Open configuration restore file");
        fci.rescanCurrentDirectory();
        fci.setSelectedFile(new File("config." + this.rep.getRemoteNodeAsString() + ".txt"));
        int retVal = fci.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        RestoreConfig.parseConfigFromFile(fci.getSelectedFile().getPath(), new RestoreConfig.ConfigCallback(){
            boolean hasError = false;

            @Override
            public void onConfigEntry(String key, String value) {
                String mapvalue;
                EntryPane pp = (EntryPane)CdiPanel.this.entriesByKey.get(key);
                if (pp == null) {
                    this.onError("Could not find variable for key " + key);
                    return;
                }
                CdiRep.Map map = pp.entry.getCdiItem().getMap();
                if (map != null && map.getKeys().size() > 0 && (mapvalue = map.getEntry(value)) != null) {
                    value = mapvalue;
                }
                pp.updateDisplayText(value);
                pp.updateColor();
            }

            @Override
            public void onError(String error) {
                if (!this.hasError) {
                    logger.severe("Error(s) encountered during loading configuration backup.");
                    this.hasError = true;
                }
                logger.severe(error);
            }
        });
        logger.info("Config load done.");
        this._unsavedRestore = true;
    }

    private void runReboot() {
        this.rep.getConnection().getDatagramService().sendData(this.rep.getRemoteNodeID(), new int[]{32, 169});
    }

    private void runUpdateComplete() {
        try {
            this.rep.getConnection().getDatagramService().sendData(this.rep.getRemoteNodeID(), new int[]{32, 168});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTabColorRefresh() {
        long currentTick;
        java.util.Timer timer = this.tabColorTimer;
        synchronized (timer) {
            currentTick = ++this.lastColorRefreshNeeded;
        }
        final long actualRequest = currentTick;
        this.tabColorTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(() -> CdiPanel.this.performTabColorRefresh(actualRequest));
            }
        }, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLoadingListener() {
        ConfigRepresentation configRepresentation = this.rep;
        synchronized (configRepresentation) {
            if (this.loadingListener != null) {
                this.rep.removePropertyChangeListener(this.loadingListener);
            }
            this.loadingListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadingListener() {
        ConfigRepresentation configRepresentation = this.rep;
        synchronized (configRepresentation) {
            this.loadingListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("UPDATE_REP")) {
                        CdiPanel.this.displayCdi();
                    } else if (event.getPropertyName().equals("UPDATE_STATE")) {
                        CdiPanel.this.loadingText.setText(CdiPanel.this.rep.getStatus());
                        Window win = SwingUtilities.getWindowAncestor(CdiPanel.this);
                        if (!CdiPanel.this.loadingIsPacked && win != null) {
                            win.pack();
                            CdiPanel.this.loadingIsPacked = true;
                        }
                    }
                }
            };
            this.rep.addPropertyChangeListener(this.loadingListener);
        }
    }

    private void hideLoadingProgress() {
        if (this.loadingPanel == null) {
            return;
        }
        this.removeLoadingListener();
        this.loadingPanel.setVisible(false);
    }

    private void displayLoadingProgress() {
        if (this.loadingPanel == null) {
            this.createLoadingPane();
        }
        this.contentPanel.add(this.loadingPanel);
        this.addLoadingListener();
    }

    private void displayCdi() {
        this.displayLoadingProgress();
        this.loadingText.setText("Creating display...");
        if (this.rep.getCdiRep().getIdentification() != null) {
            this.contentPanel.add(this.createIdentificationPane(this.rep.getCdiRep()));
        }
        this.repack();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CdiPanel.this.rep.visit(new RendererVisitor());
                EventQueue.invokeLater(() -> CdiPanel.this.displayComplete());
            }
        }, "openlcb-cdi-render").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayComplete() {
        Object object = this.startupTasks;
        synchronized (object) {
            this.renderingInProgress = false;
        }
        this.startupTasks.forEach(r -> r.run());
        this.hideLoadingProgress();
        this.contentPanel.add(Box.createVerticalGlue());
        this.repack();
        object = this.tabColorTimer;
        synchronized (object) {
            this.lastColorRefreshDone = 0L;
        }
        this.setSaveClean();
        this.notifyTabColorRefresh();
        SwingUtilities.invokeLater(() -> {
            JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            if (f == null) {
                logger.log(Level.FINE, "Could not add close window listener");
                return;
            }
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CdiPanel.this.targetWindowClosingEvent(e);
                }
            });
        });
        this.segmentPanels.forEach(p -> p.setExpanded(false));
    }

    private void targetWindowClosingEvent(WindowEvent e) {
        StringBuilder sb = new StringBuilder();
        if (this._unsavedRestore) {
            sb.append("The configuration was restored but not saved.");
            sb.append("\n");
        }
        boolean save = this._unsavedRestore;
        int num_dirty = 0;
        int MAX_DIRTY_TO_SHOW = 10;
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDirty()) continue;
            if (++num_dirty <= 10) {
                GetEntryNameVisitor nameGetter = new GetEntryNameVisitor(entry);
                this.rep.visit(nameGetter);
                sb.append(nameGetter.getName());
                sb.append(" has not been saved.");
                sb.append("\n");
            }
            save = true;
        }
        if (num_dirty > 10) {
            sb.append(num_dirty - 10);
            sb.append(" additional entries have not been saved.");
            sb.append("\n");
        }
        if (this._panelChange) {
            sb.append("The panel tables have been changed. To keep these changes, save the panel file.");
            sb.append("\n");
        }
        if (num_dirty > 0) {
            sb.append("\nPress Cancel to go back and save these changes.");
            Object[] options = new Object[]{"Discard changes", "Cancel"};
            int confirm = JOptionPane.showOptionDialog(this, sb.toString(), "Unsaved changes", -1, 2, null, options, options[1]);
            if (confirm != 0) {
                return;
            }
        } else if (this._panelChange) {
            JOptionPane.showMessageDialog(this, sb.toString(), "Tables are changed", 1);
        }
        if (this._changeMade) {
            this.runUpdateComplete();
        }
        this.release();
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        f.dispose();
    }

    private void setSaveDirty() {
        SwingUtilities.invokeLater(() -> {
            this._saveButton.setBackground(COLOR_EDITED);
            this._saveButton.setEnabled(true);
        });
    }

    private void setSaveClean() {
        SwingUtilities.invokeLater(() -> {
            this._saveButton.setBackground(this.COLOR_DEFAULT);
            this._saveButton.setEnabled(false);
        });
    }

    private void repack() {
        Window win = SwingUtilities.getWindowAncestor(this);
        if (win != null) {
            win.pack();
        }
    }

    private void updateWidth() {
        int w = this.getSize().width - 4;
        this.runNowOrLater(() -> this.segmentPanels.forEach(p -> p.setMaximumWidth(w)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTabColorRefresh(long requestTick) {
        java.util.Timer timer = this.tabColorTimer;
        synchronized (timer) {
            if (this.lastColorRefreshDone >= requestTick) {
                return;
            }
            this.lastColorRefreshDone = this.lastColorRefreshNeeded;
        }
        this.rep.visit(new ConfigRepresentation.Visitor(){
            boolean isDirty = false;

            @Override
            public void visitGroupRep(ConfigRepresentation.GroupRep e) {
                boolean oldDirty = this.isDirty;
                this.isDirty = false;
                super.visitGroupRep(e);
                JTabbedPane tabs = (JTabbedPane)CdiPanel.this.tabsByKey.get(e.key);
                if (tabs != null && tabs.getTabCount() >= e.index) {
                    if (this.isDirty) {
                        tabs.setBackgroundAt(e.index - 1, COLOR_EDITED);
                    } else {
                        tabs.setBackgroundAt(e.index - 1, null);
                    }
                }
                this.isDirty |= oldDirty;
            }

            @Override
            public void visitLeaf(ConfigRepresentation.CdiEntry e) {
                EntryPane v = (EntryPane)CdiPanel.this.entriesByKey.get(e.key);
                this.isDirty |= v.isDirty();
            }
        });
        this.checkForSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNowOrLater(Runnable r) {
        ArrayList<Runnable> arrayList = this.startupTasks;
        synchronized (arrayList) {
            if (this.renderingInProgress) {
                this.startupTasks.add(r);
                return;
            }
        }
        r.run();
    }

    void createLoadingPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(0.0f);
        p.setBorder(BorderFactory.createTitledBorder("Loading"));
        this.loadingText = new JLabel(this.rep.getStatus());
        this.loadingText.setPreferredSize(new Dimension(400, 20));
        this.loadingText.setMinimumSize(new Dimension(400, 20));
        this.loadingText.setAlignmentX(0.0f);
        p.add(this.loadingText);
        this.reloadButton = new JButton("Re-try");
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CdiPanel.this.rep.restartIfNeeded();
            }
        });
        this.reloadButton.setAlignmentX(0.0f);
        this.reloadButton.setAlignmentY(0.0f);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(this.reloadButton);
        p.add(p1);
        this.loadingPanel = p;
    }

    JPanel createIdentificationPane(CdiRep c) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(0.0f);
        CdiRep.Identification id = c.getIdentification();
        JPanel p1 = new JPanel();
        p.add(p1);
        p1.setLayout(new GridLayout2(4, 2));
        p1.setAlignmentX(0.0f);
        p1.add(new JLabel("Manufacturer: "));
        p1.add(new JLabel(id.getManufacturer()));
        p1.add(new JLabel("Model: "));
        p1.add(new JLabel(id.getModel()));
        p1.add(new JLabel("Hardware Version: "));
        p1.add(new JLabel(id.getHardwareVersion()));
        p1.add(new JLabel("Software Version: "));
        p1.add(new JLabel(id.getSoftwareVersion()));
        p1.setMaximumSize(p1.getPreferredSize());
        JPanel p2 = this.createPropertyPane(id.getMap());
        if (p2 != null) {
            p2.setAlignmentX(0.0f);
            p.add(p2);
        }
        CollapsiblePanel ret = new CollapsiblePanel("Identification", p);
        this.segmentPanels.add(ret);
        ret.setAlignmentY(0.0f);
        ret.setAlignmentX(0.0f);
        return ret;
    }

    JPanel createPropertyPane(CdiRep.Map map) {
        if (map != null) {
            JPanel p2 = new JPanel();
            p2.setAlignmentX(0.0f);
            p2.setBorder(BorderFactory.createTitledBorder("Properties"));
            List<String> keys = map.getKeys();
            if (keys.isEmpty()) {
                return null;
            }
            p2.setLayout(new GridLayout2(keys.size(), 2));
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                p2.add(new JLabel(key + ": "));
                p2.add(new JLabel(map.getEntry(key)));
            }
            p2.setMaximumSize(p2.getPreferredSize());
            return p2;
        }
        return null;
    }

    void createDescriptionPane(JPanel parent, String d) {
        if (d == null) {
            return;
        }
        if (d.trim().length() == 0) {
            return;
        }
        JTextArea area = new JTextArea(d){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
        area.setAlignmentX(0.0f);
        area.setFont(UIManager.getFont("TextArea.font"));
        area.setEditable(false);
        area.setOpaque(false);
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        parent.add(area);
    }

    private void addCopyPasteButtons(JPanel linePanel, final JTextField textField) {
        final JButton b = new JButton("Copy");
        final Color defaultColor = b.getBackground();
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String s = textField.getText();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textField.selectAll();
                    }
                });
                StringSelection eventToCopy = new StringSelection(s);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(eventToCopy, new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                        b.setBackground(defaultColor);
                        b.setText("Copy");
                    }
                });
                b.setBackground(COLOR_COPIED);
                b.setText("Copied");
            }
        });
        linePanel.add(b);
        JButton bb = new JButton("Paste");
        bb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                DataFlavor dataFlavor = DataFlavor.stringFlavor;
                Object text = null;
                try {
                    text = systemClipboard.getData(dataFlavor);
                }
                catch (UnsupportedFlavorException | IOException e1) {
                    return;
                }
                String pasteValue = (String)text;
                if (pasteValue != null) {
                    textField.setText(pasteValue);
                }
            }
        });
        linePanel.add(bb);
    }

    public static class GuiItemFactory {
        public JButton handleReadButton(JButton button) {
            return button;
        }

        public JButton handleWriteButton(JButton button) {
            return button;
        }

        public void handleGroupPaneStart(JPanel pane) {
        }

        public void handleGroupPaneEnd(JPanel pane) {
        }

        public JFormattedTextField handleEventIdTextField(JFormattedTextField field) {
            return field;
        }

        public JTextField handleStringValue(JTextField value) {
            return value;
        }

        public JTextArea handleEditorValue(JTextArea value) {
            return value;
        }
    }

    private class StringPane
    extends EntryPane {
        JTextComponent textField;
        private final ConfigRepresentation.StringEntry entry;

        StringPane(ConfigRepresentation.StringEntry e) {
            super(e, "String");
            this.entry = e;
            if (this.entry.size <= 64) {
                JTextField jtf = new JTextField(this.entry.size){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                jtf = CdiPanel.this.factory.handleStringValue(jtf);
                this.textField = jtf;
            } else {
                JTextArea jta = new JTextArea(Math.min(40, this.entry.size / 60), 80);
                jta.setEditable(true);
                jta.setLineWrap(true);
                jta.setWrapStyleWord(true);
                jta = CdiPanel.this.factory.handleEditorValue(jta);
                this.textField = jta;
            }
            this.textComponent = this.textField;
            this.textComponent.setToolTipText("String of up to " + this.entry.size + " characters");
            this.init();
        }

        @Override
        protected void writeDisplayTextToNode() {
            this.entry.setValue(this.textField.getText());
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            this.textField.setText(value);
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }
    }

    private class IntPane
    extends EntryPane {
        JTextField textField;
        JComboBox box;
        CdiRep.Map map;
        private final ConfigRepresentation.IntegerEntry entry;

        IntPane(ConfigRepresentation.IntegerEntry e) {
            super(e, "Integer");
            this.textField = null;
            this.box = null;
            this.map = null;
            this.entry = e;
            this.map = this.item.getMap();
            if (this.map != null && this.map.getKeys().size() > 0) {
                this.box = new JComboBox(this.map.getValues().toArray(new String[]{""})){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.textComponent = this.box;
            } else {
                this.textField = new JTextField(24){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.textComponent = this.textField;
                this.textField.setToolTipText("Signed integer value of up to " + this.entry.size + " bytes");
            }
            this.init();
        }

        @Override
        protected void writeDisplayTextToNode() {
            long value;
            if (this.textField != null) {
                value = Long.parseLong(this.textField.getText());
            } else {
                String entry = (String)this.box.getSelectedItem();
                String key = this.map.getKey(entry);
                value = Long.parseLong(key);
            }
            this.entry.setValue(value);
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            if (this.textField != null) {
                this.textField.setText(value);
            }
            if (this.box != null) {
                this.box.setSelectedItem(value);
            }
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.box == null ? this.textField.getText() : (String)this.box.getSelectedItem();
            return s == null ? "" : s;
        }
    }

    private class EventIdPane
    extends EntryPane {
        private final ConfigRepresentation.EventEntry entry;
        JFormattedTextField textField;
        JLabel eventNamesLabel;
        EventTable.EventTableEntryHolder eventTableEntryHolder;
        String lastEventText;
        PropertyChangeListener eventListUpdateListener;
        Map<String, String> parentVisibleKeys;

        EventIdPane(ConfigRepresentation.EventEntry e) {
            super(e, "EventID");
            this.eventNamesLabel = null;
            this.eventTableEntryHolder = null;
            this.parentVisibleKeys = new TreeMap(Collections.reverseOrder());
            this.entry = e;
            this.textField = CdiPanel.this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
            this.textComponent = this.textField;
            if (CdiPanel.this.eventTable != null) {
                this.eventNamesLabel = new JLabel();
                this.eventNamesLabel.setFont(UIManager.getFont("TextArea.font"));
                this.eventNamesLabel.setVisible(false);
                this.eventListUpdateListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("UPDATED_EVENT_LIST")) {
                            EventIdPane.this.updateEventDescriptionField((EventTable.EventInfo)propertyChangeEvent.getNewValue());
                        }
                    }
                };
                CdiPanel.this.cleanupTasks.add(() -> this.releaseListener());
            }
            this.init();
            if (CdiPanel.this.eventTable != null) {
                this.add(this.eventNamesLabel);
            }
        }

        private void updateEventDescriptionField(EventTable.EventInfo eventInfo) {
            EventTable.EventTableEntry[] elist = eventInfo.getAllEntries();
            StringBuilder b = new StringBuilder();
            b.append("<html><body>");
            boolean first = true;
            for (EventTable.EventTableEntry ee : elist) {
                if (ee.isOwnedBy(this.eventTableEntryHolder)) continue;
                if (first) {
                    b.append("Other uses of this Event ID:<br>");
                    first = false;
                } else {
                    b.append("<br>");
                }
                b.append(ee.getDescription());
            }
            b.append("</body></html>");
            if (first) {
                this.eventNamesLabel.setVisible(false);
            } else {
                this.eventNamesLabel.setText(b.toString());
                this.eventNamesLabel.setVisible(true);
            }
        }

        void updateOwnEventName() {
            if (this.eventTableEntryHolder == null) {
                return;
            }
            this.eventTableEntryHolder.getEntry().updateDescription(this.getEventName());
        }

        private String getEventName() {
            StringBuilder b = new StringBuilder(this.entry.key);
            this.parentVisibleKeys.forEach((k, v) -> {
                if (v.trim().length() > 0) {
                    b.insert(k.length() - 1, "," + v);
                }
            });
            Matcher m = segmentPrefixRe.matcher(b);
            if (m.find()) {
                b.delete(m.start(), m.end());
            }
            if ((m = entrySuffixRe.matcher(b)).find()) {
                b.delete(m.start(), m.end());
            }
            if (CdiPanel.this.nodeName.length() > 0) {
                b.insert(0, CdiPanel.this.nodeName);
                b.insert(CdiPanel.this.nodeName.length(), ".");
            }
            for (int i = b.length() - 1; i >= 0; --i) {
                int j;
                if (b.charAt(i) != '(') continue;
                for (j = i + 1; j < b.length() && Character.isDigit(b.charAt(j)); ++j) {
                }
                if (j <= i + 1) continue;
                int val = Integer.parseInt(b.substring(i + 1, j));
                b.replace(i + 1, j, Integer.toString(++val));
            }
            return b.toString();
        }

        @Override
        protected void additionalButtons() {
            final JFormattedTextField tf = this.textField;
            this.p3.add(Box.createHorizontalStrut(5));
            CdiPanel.this.addCopyPasteButtons(this.p3, this.textField);
            this.p3.add(Box.createHorizontalStrut(5));
            JButton b = new JButton("Search");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CdiPanel.this.searchPane.attachParent(EventIdPane.this.p3, tf);
                }
            });
            this.p3.add(b);
            this.p3.add(Box.createHorizontalStrut(5));
        }

        @Override
        protected void writeDisplayTextToNode() {
            byte[] contents = Utilities.bytesFromHexString(this.textField.getText());
            this.entry.setValue(new EventID(contents));
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            this.textField.setText(value);
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }

        @Override
        void updateColor() {
            EventID id;
            super.updateColor();
            if (CdiPanel.this.eventTable == null) {
                return;
            }
            String s = this.textField.getText();
            if (s.equals(this.lastEventText)) {
                return;
            }
            this.lastEventText = s;
            try {
                id = new EventID(s);
            }
            catch (RuntimeException e) {
                return;
            }
            if (this.eventTableEntryHolder != null) {
                if (this.eventTableEntryHolder.getEntry().getEvent().equals(id)) {
                    return;
                }
                this.releaseListener();
            }
            if (id.equals(BitProducerConsumer.nullEvent)) {
                this.eventNamesLabel.setVisible(false);
                return;
            }
            this.eventTableEntryHolder = CdiPanel.this.eventTable.addEvent(id, this.getEventName());
            this.eventTableEntryHolder.getList().addPropertyChangeListener(this.eventListUpdateListener);
            this.updateEventDescriptionField(this.eventTableEntryHolder.getList());
        }

        private void releaseListener() {
            if (this.eventTableEntryHolder == null) {
                return;
            }
            this.eventTableEntryHolder.getList().removePropertyChangeListener(this.eventListUpdateListener);
            this.eventTableEntryHolder.release();
            this.eventTableEntryHolder = null;
        }
    }

    private abstract class EntryPane
    extends JPanel {
        protected final CdiRep.Item item;
        protected JComponent textComponent;
        private ConfigRepresentation.CdiEntry entry;
        PropertyChangeListener entryListener = null;
        boolean dirty = false;
        JPanel p3;

        EntryPane(ConfigRepresentation.CdiEntry e, String defaultName) {
            this.item = e.getCdiItem();
            this.entry = e;
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentX(0.0f);
            String name = this.item.getName() != null ? this.item.getName() : defaultName;
            this.setBorder(BorderFactory.createTitledBorder(name));
            CdiPanel.this.createDescriptionPane(this, this.item.getDescription());
            this.p3 = new JPanel();
            this.p3.setAlignmentX(0.0f);
            this.p3.setLayout(new BoxLayout(this.p3, 0));
            this.add(this.p3);
        }

        void release() {
            if (this.entryListener != null) {
                this.entry.removePropertyChangeListener(this.entryListener);
            }
        }

        protected void additionalButtons() {
        }

        protected void init() {
            if (this.textComponent instanceof JTextArea) {
                this.p3.add(new JScrollPane(this.textComponent));
            } else {
                this.p3.add(this.textComponent);
            }
            this.textComponent.setMaximumSize(this.textComponent.getPreferredSize());
            if (this.textComponent instanceof JTextComponent) {
                ((JTextComponent)this.textComponent).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    private void drawRed() {
                        EntryPane.this.updateColor();
                    }
                });
            } else if (this.textComponent instanceof JComboBox) {
                ((JComboBox)this.textComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EntryPane.this.updateColor();
                    }
                });
            }
            this.entryListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("UPDATE_ENTRY_DATA")) {
                        String v = ((EntryPane)EntryPane.this).entry.lastVisibleValue;
                        if (v == null) {
                            v = "";
                        }
                        EntryPane.this.updateDisplayText(v);
                        EntryPane.this.updateColor();
                    } else if (propertyChangeEvent.getPropertyName().equals("PENDING_WRITE_COMPLETE")) {
                        EntryPane.this.updateColor();
                    }
                }
            };
            this.entry.addPropertyChangeListener(this.entryListener);
            CdiPanel.this.cleanupTasks.add(new Runnable(){

                @Override
                public void run() {
                    EntryPane.this.entry.removePropertyChangeListener(EntryPane.this.entryListener);
                }
            });
            this.entry.fireUpdate();
            JButton b = CdiPanel.this.factory.handleReadButton(new JButton("Refresh"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntryPane.this.entry.reload();
                }
            });
            this.p3.add(b);
            b = CdiPanel.this.factory.handleWriteButton(new JButton("Write"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntryPane.this.writeDisplayTextToNode();
                }
            });
            this.p3.add(b);
            this.additionalButtons();
            this.p3.add(Box.createHorizontalGlue());
        }

        void updateColor() {
            if (this.entry.lastVisibleValue == null) {
                this.textComponent.setBackground(COLOR_UNFILLED);
                return;
            }
            String v = this.getDisplayText();
            boolean oldDirty = this.dirty;
            if (v.equals(this.entry.lastVisibleValue)) {
                this.textComponent.setBackground(COLOR_WRITTEN);
                this.dirty = false;
            } else {
                this.textComponent.setBackground(COLOR_EDITED);
                this.dirty = true;
                CdiPanel.this.setSaveDirty();
            }
            if (oldDirty != this.dirty) {
                CdiPanel.this.notifyTabColorRefresh();
            }
        }

        boolean isDirty() {
            return this.dirty;
        }

        protected abstract void writeDisplayTextToNode();

        protected abstract void updateDisplayText(@NonNull String var1);

        @NonNull
        protected abstract String getDisplayText();
    }

    public class GroupPane
    extends JPanel {
        private final ConfigRepresentation.GroupEntry entry;
        private final CdiRep.Item item;

        GroupPane(ConfigRepresentation.GroupEntry e) {
            this.entry = e;
            this.item = e.getCdiItem();
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentX(0.0f);
            String name = this.item.getName() != null ? this.item.getName() : "Group";
            this.setBorder(BorderFactory.createTitledBorder(name));
            this.setName(name);
            CdiPanel.this.createDescriptionPane(this, this.item.getDescription());
            JPanel p2 = CdiPanel.this.createPropertyPane(this.item.getMap());
            if (p2 != null) {
                this.add(p2);
            }
        }
    }

    private class SearchPane
    extends JPanel {
        JPanel parent = null;
        JTextField textField;
        JTextField outputField;
        JPopupMenu suggestMenu = null;

        SearchPane() {
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentX(0.0f);
            this.textField = new JTextField(32);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
            this.textField.setToolTipText("Enter the description of an event here to help pasting the event ID.");
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }
            });
            this.textField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        SearchPane.this.cancelSearch();
                    } else if (keyEvent.getKeyCode() == 40 && SearchPane.this.suggestMenu != null && SearchPane.this.suggestMenu.isVisible()) {
                        SearchPane.this.suggestMenu.setVisible(false);
                        SearchPane.this.suggestMenu.setFocusable(true);
                        SearchPane.this.suggestMenu.getSelectionModel().setSelectedIndex(0);
                        SearchPane.this.suggestMenu.show(SearchPane.this.textField, 0, SearchPane.this.textField.getHeight());
                        Timer t = new Timer(100, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    Robot r = new Robot();
                                    r.keyPress(40);
                                    r.keyRelease(40);
                                }
                                catch (AWTException aWTException) {
                                    // empty catch block
                                }
                            }
                        });
                        t.setRepeats(false);
                        t.start();
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }

        private void textUpdated() {
            if (this.parent == null) {
                return;
            }
            String searchQuery = this.textField.getText();
            logger.log(Level.FINE, String.format("Search for: %s", searchQuery));
            boolean fresh = false;
            if (this.suggestMenu == null) {
                this.suggestMenu = new JPopupMenu();
                fresh = true;
            }
            long startTime = System.nanoTime();
            List<EventTable.EventTableEntry> results = CdiPanel.this.eventTable.searchForEvent(searchQuery, 8);
            long timelen = System.nanoTime() - startTime;
            logger.log(Level.FINE, String.format("Search took %.2f msec", (double)timelen * 1.0 / 1000000.0));
            this.suggestMenu.removeAll();
            for (final EventTable.EventTableEntry result : results) {
                AbstractAction a = new AbstractAction(result.getDescription()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String r = Utilities.toHexDotsString(result.getEvent().getContents());
                        SearchPane.this.outputField.setText(r);
                        SearchPane.this.cancelSearch();
                    }
                };
                this.suggestMenu.add(a);
            }
            if (results.isEmpty()) {
                this.suggestMenu.add("No matches.");
            }
            this.suggestMenu.setFocusable(false);
            if (!fresh) {
                this.suggestMenu.revalidate();
                this.suggestMenu.pack();
                this.suggestMenu.repaint();
            }
            this.suggestMenu.show(this.textField, 0, this.textField.getHeight());
        }

        private void cancelSearch() {
            logger.log(Level.FINE, "Removing search box");
            if (this.suggestMenu != null) {
                this.suggestMenu.setVisible(false);
            }
            if (this.parent != null) {
                this.parent.remove(this.textField);
                this.parent.revalidate();
                this.parent.repaint();
                this.parent = null;
            }
        }

        void attachParent(JPanel parentPane, JTextField output) {
            if (this.parent != null) {
                this.cancelSearch();
            }
            this.textField.setText("");
            parentPane.add(this.textField);
            this.parent = parentPane;
            this.outputField = output;
            parentPane.revalidate();
            this.textField.requestFocusInWindow();
        }
    }

    public class SegmentPane
    extends JPanel {
        SegmentPane(ConfigRepresentation.SegmentEntry item) {
            SegmentPane p = this;
            p.setLayout(new BoxLayout(p, 1));
            p.setAlignmentX(0.0f);
            p.setAlignmentY(0.0f);
            CdiPanel.this.createDescriptionPane(this, item.getDescription());
            JPanel p2 = CdiPanel.this.createPropertyPane(item.getMap());
            if (p2 != null) {
                p.add(p2);
            }
        }
    }

    private class RendererVisitor
    extends ConfigRepresentation.Visitor {
        private JPanel currentPane;
        private EntryPane currentLeaf;
        private JTabbedPane currentTabbedPane;

        private RendererVisitor() {
        }

        @Override
        public void visitSegment(ConfigRepresentation.SegmentEntry e) {
            this.currentPane = new SegmentPane(e);
            super.visitSegment(e);
            String name = "Segment" + (e.getName() != null ? ": " + e.getName() : "");
            CollapsiblePanel ret = new CollapsiblePanel(name, this.currentPane);
            CdiPanel.this.segmentPanels.add(ret);
            ret.setAlignmentY(0.0f);
            ret.setAlignmentX(0.0f);
            ret.setBorder(BorderFactory.createMatteBorder(10, 0, 0, 0, CdiPanel.this.getForeground()));
            CdiPanel.this.contentPanel.add(ret);
        }

        @Override
        public void visitGroup(ConfigRepresentation.GroupEntry e) {
            JPanel oldPane = this.currentPane;
            JTabbedPane oldTabbed = this.currentTabbedPane;
            GroupPane groupPane = new GroupPane(e);
            this.currentPane = groupPane;
            if (e.group.getReplication() > 1) {
                this.currentTabbedPane = new JTabbedPane();
                this.currentTabbedPane.setAlignmentX(0.0f);
                this.currentPane.add(this.currentTabbedPane);
            }
            CdiPanel.this.factory.handleGroupPaneStart(groupPane);
            super.visitGroup(e);
            CdiPanel.this.factory.handleGroupPaneEnd(groupPane);
            if (groupPane.getComponentCount() > 0) {
                if (oldPane instanceof SegmentPane) {
                    groupPane.setBorder(null);
                    CollapsiblePanel ret = new CollapsiblePanel(groupPane.getName(), groupPane);
                    ret.setAlignmentY(0.0f);
                    ret.setAlignmentX(0.0f);
                    oldPane.add(ret);
                } else {
                    oldPane.add(groupPane);
                }
            }
            this.currentPane = oldPane;
            this.currentTabbedPane = oldTabbed;
        }

        @Override
        public void visitGroupRep(final ConfigRepresentation.GroupRep e) {
            this.currentPane = new JPanel();
            this.currentPane.setLayout(new BoxLayout(this.currentPane, 1));
            this.currentPane.setAlignmentX(0.0f);
            CdiRep.Group item = e.group;
            final String name = (item.getRepName() != null ? item.getRepName() : "Group") + " " + e.index;
            this.currentPane.setName(name);
            FindDescriptorVisitor vv = new FindDescriptorVisitor();
            vv.visitContainer(e);
            if (vv.foundEntry != null) {
                final JPanel tabPanel = this.currentPane;
                final ConfigRepresentation.StringEntry source = vv.foundEntry;
                final JTabbedPane parentTabs = this.currentTabbedPane;
                PropertyChangeListener l = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("UPDATE_ENTRY_DATA")) {
                            CdiPanel.this.runNowOrLater(() -> {
                                String downstreamName = "";
                                if (source2.lastVisibleValue != null && !source2.lastVisibleValue.isEmpty()) {
                                    String newName = name + " (" + source2.lastVisibleValue + ")";
                                    tabPanel.setName(newName);
                                    if (parentTabs.getTabCount() >= e2.index) {
                                        parentTabs.setTitleAt(e2.index - 1, newName);
                                    }
                                    downstreamName = source2.lastVisibleValue;
                                } else if (parentTabs.getTabCount() >= e2.index) {
                                    parentTabs.setTitleAt(e2.index - 1, name);
                                }
                                new UpdateGroupNameVisitor(e2.key, downstreamName).visitContainer(e);
                            });
                        }
                    }
                };
                source.addPropertyChangeListener(l);
                CdiPanel.this.cleanupTasks.add(() -> source.removePropertyChangeListener(l));
            }
            CdiPanel.this.factory.handleGroupPaneStart(this.currentPane);
            super.visitGroupRep(e);
            CdiPanel.this.factory.handleGroupPaneEnd(this.currentPane);
            this.currentPane.add(Box.createVerticalGlue());
            this.currentTabbedPane.add(this.currentPane);
            CdiPanel.this.tabsByKey.put(e.key, this.currentTabbedPane);
        }

        @Override
        public void visitString(ConfigRepresentation.StringEntry e) {
            this.currentLeaf = new StringPane(e);
            super.visitString(e);
        }

        @Override
        public void visitInt(ConfigRepresentation.IntegerEntry e) {
            this.currentLeaf = new IntPane(e);
            super.visitInt(e);
        }

        @Override
        public void visitEvent(ConfigRepresentation.EventEntry e) {
            this.currentLeaf = new EventIdPane(e);
            super.visitEvent(e);
        }

        @Override
        public void visitLeaf(ConfigRepresentation.CdiEntry e) {
            CdiPanel.this.allEntries.add(this.currentLeaf);
            CdiPanel.this.entriesByKey.put(((EntryPane)this.currentLeaf).entry.key, this.currentLeaf);
            this.currentLeaf.setAlignmentX(0.0f);
            this.currentPane.add(this.currentLeaf);
            this.currentLeaf = null;
        }
    }

    private class UpdateGroupNameVisitor
    extends ConfigRepresentation.Visitor {
        String baseGroupKey;
        String labelValue;

        UpdateGroupNameVisitor(String baseGroupKey, String labelValue) {
            this.baseGroupKey = baseGroupKey;
            this.labelValue = labelValue;
        }

        @Override
        public void visitEvent(ConfigRepresentation.EventEntry e) {
            EventIdPane pane = (EventIdPane)CdiPanel.this.entriesByKey.get(e.key);
            if (pane == null) {
                return;
            }
            pane.parentVisibleKeys.put(this.baseGroupKey, this.labelValue);
            pane.updateOwnEventName();
        }
    }

    private class FindDescriptorVisitor
    extends ConfigRepresentation.Visitor {
        public boolean foundUnique = false;
        public ConfigRepresentation.StringEntry foundEntry = null;

        private FindDescriptorVisitor() {
        }

        @Override
        public void visitString(ConfigRepresentation.StringEntry e) {
            if (this.foundEntry != null) {
                this.foundUnique = false;
            } else {
                this.foundUnique = true;
                this.foundEntry = e;
            }
        }

        @Override
        public void visitGroupRep(ConfigRepresentation.GroupRep e) {
        }
    }

    private class GetEntryNameVisitor
    extends ConfigRepresentation.Visitor {
        CdiRep.Item item;
        int segNum = 1;
        String segName = null;
        String groupName = null;
        String groupRepName = null;
        String entryName = null;
        String fullName = null;
        boolean done = false;

        GetEntryNameVisitor(EntryPane ep) {
            this.item = ep.item;
        }

        @Override
        public void visitSegment(ConfigRepresentation.SegmentEntry e) {
            if (!this.done) {
                this.groupName = null;
                this.groupRepName = null;
                this.segName = e.segment.getName();
                ++this.segNum;
                this.visitContainer(e);
            }
        }

        @Override
        public void visitGroupRep(ConfigRepresentation.GroupRep e) {
            if (!this.done) {
                this.groupRepName = e.group.getName() + e.index;
                this.visitContainer(e);
            }
        }

        @Override
        public void visitGroup(ConfigRepresentation.GroupEntry e) {
            if (!this.done) {
                this.groupName = e.group.getName();
                this.visitContainer(e);
            }
        }

        @Override
        public void visitLeaf(ConfigRepresentation.CdiEntry e) {
            if (!this.done && this.item.equals(e.getCdiItem())) {
                this.entryName = e.getCdiItem().getName();
                StringBuilder sb = new StringBuilder();
                sb.append("Item \"");
                sb.append(this.entryName);
                sb.append("\"");
                if (this.groupRepName == null) {
                    this.groupRepName = this.groupName;
                } else if (this.groupName != null) {
                    sb.append(" in ");
                    sb.append(this.groupName);
                }
                if (this.groupRepName != null) {
                    sb.append(" of group \"");
                    sb.append(this.groupRepName);
                    sb.append("\"");
                }
                sb.append(" in segment ");
                if (this.segName == null || this.segName.isEmpty()) {
                    sb.append("#");
                    sb.append(this.segNum);
                } else {
                    sb.append(this.segName);
                }
                this.fullName = sb.toString();
                this.done = true;
            }
        }

        String getName() {
            if (this.fullName == null) {
                return "NotFound";
            }
            return this.fullName;
        }
    }
}

