/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.jdom;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.openlcb.cdi.CdiRep;

public class JdomCdiRep
implements CdiRep {
    Element root;

    public JdomCdiRep(Element root) {
        this.root = root;
    }

    @Override
    public Identification getIdentification() {
        Element id = this.root.getChild("identification");
        if (id == null) {
            return null;
        }
        return new Identification(id);
    }

    @Override
    public List<CdiRep.Segment> getSegments() {
        List list = this.root.getChildren("segment");
        ArrayList<CdiRep.Segment> result = new ArrayList<CdiRep.Segment>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(new Segment((Element)list.get(i)));
        }
        return result;
    }

    public static class StringRep
    extends Item
    implements CdiRep.StringRep {
        StringRep(Element e) {
            super(e);
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class BitRep
    extends Item
    implements CdiRep.BitRep {
        BitRep(Element e) {
            super(e);
        }

        @Override
        public boolean getDefault() {
            return false;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class IntRep
    extends Item
    implements CdiRep.IntegerRep {
        IntRep(Element e) {
            super(e);
        }

        @Override
        public int getDefault() {
            return 0;
        }

        @Override
        public int getMin() {
            return 0;
        }

        @Override
        public int getMax() {
            return 0;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class EventID
    extends Item
    implements CdiRep.EventID {
        EventID(Element e) {
            super(e);
        }
    }

    public static class Group
    extends Nested
    implements CdiRep.Group {
        Group(Element e) {
            super(e);
        }

        @Override
        public int getReplication() {
            Attribute a = this.e.getAttribute("replication");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public int getOffset() {
            Attribute a = this.e.getAttribute("offset");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public String getRepName() {
            Element d = this.e.getChild("repname");
            if (d == null) {
                return null;
            }
            return d.getText();
        }
    }

    public static class Item
    implements CdiRep.Item {
        Element e;

        Item(Element e) {
            this.e = e;
        }

        @Override
        public String getName() {
            Element d = this.e.getChild("name");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        @Override
        public String getDescription() {
            Element d = this.e.getChild("description");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        @Override
        public Map getMap() {
            return new Map(this.e.getChild("map"));
        }

        @Override
        public int getOffset() {
            Attribute a = this.e.getAttribute("offset");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e) {
                return 0;
            }
        }

        @Override
        public int getIndexInParent() {
            return this.e.getParent().indexOf((Content)this.e);
        }
    }

    public static class Map
    implements CdiRep.Map {
        Element map;

        Map(Element map) {
            this.map = map;
        }

        @Override
        public String getEntry(String key) {
            List relations = this.map.getChildren("relation");
            for (int i = 0; i < relations.size(); ++i) {
                if (!key.equals(((Element)relations.get(i)).getChild("property").getText())) continue;
                return ((Element)relations.get(i)).getChild("value").getText();
            }
            return null;
        }

        @Override
        public String getKey(String entry) {
            List relations = this.map.getChildren("relation");
            for (int i = 0; i < relations.size(); ++i) {
                if (!entry.equals(((Element)relations.get(i)).getChild("value").getText())) continue;
                return ((Element)relations.get(i)).getChild("property").getText();
            }
            return null;
        }

        @Override
        public List<String> getKeys() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.map == null) {
                return list;
            }
            List relations = this.map.getChildren("relation");
            if (relations == null) {
                return list;
            }
            for (int i = 0; i < relations.size(); ++i) {
                list.add(((Element)relations.get(i)).getChild("property").getText());
            }
            return list;
        }

        @Override
        public List<String> getValues() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.map == null) {
                return list;
            }
            List relations = this.map.getChildren("relation");
            if (relations == null) {
                return list;
            }
            for (int i = 0; i < relations.size(); ++i) {
                list.add(((Element)relations.get(i)).getChild("value").getText());
            }
            return list;
        }
    }

    public static class Segment
    extends Nested
    implements CdiRep.Segment {
        Segment(Element segment) {
            super(segment);
        }

        @Override
        public int getSpace() {
            Attribute a = this.e.getAttribute("space");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public int getOrigin() {
            Attribute a = this.e.getAttribute("origin");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    static class Nested {
        Element e;

        public String getName() {
            Element d = this.e.getChild("name");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        public String getDescription() {
            Element d = this.e.getChild("description");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        public Map getMap() {
            return new Map(this.e.getChild("map"));
        }

        public List<CdiRep.Item> getItems() {
            ArrayList<CdiRep.Item> list = new ArrayList<CdiRep.Item>();
            if (this.e == null) {
                return list;
            }
            List elements = this.e.getChildren();
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                if ("group".equals(element.getName())) {
                    list.add(new Group(element));
                    continue;
                }
                if ("bit".equals(element.getName())) {
                    list.add(new BitRep(element));
                    continue;
                }
                if ("int".equals(element.getName())) {
                    list.add(new IntRep(element));
                    continue;
                }
                if ("eventid".equals(element.getName())) {
                    list.add(new EventID(element));
                    continue;
                }
                if (!"string".equals(element.getName())) continue;
                list.add(new StringRep(element));
            }
            return list;
        }

        public int getIndexInParent() {
            return this.e.getParent().indexOf((Content)this.e);
        }

        Nested(Element e) {
            this.e = e;
        }
    }

    public static class Identification
    implements CdiRep.Identification {
        Element id;

        @Override
        public String getManufacturer() {
            Element c = this.id.getChild("manufacturer");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getModel() {
            Element c = this.id.getChild("model");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getHardwareVersion() {
            Element c = this.id.getChild("hardwareVersion");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getSoftwareVersion() {
            Element c = this.id.getChild("softwareVersion");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public Map getMap() {
            return new Map(this.id.getChild("map"));
        }

        Identification(Element id) {
            this.id = id;
        }
    }
}

