/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.jdom;

import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.MemoryConfigurationService;

public class CdiMemConfigReader {
    private static final Logger logger = Logger.getLogger(CdiMemConfigReader.class.getName());
    static final int LENGTH = 64;
    NodeID node;
    MimicNodeStore store;
    MemoryConfigurationService service;
    final int space;
    long nextAddress = 0L;
    StringBuffer buf;
    ReaderAccess retval;

    public CdiMemConfigReader(NodeID node, MimicNodeStore store, MemoryConfigurationService service) {
        this.node = node;
        this.store = store;
        this.service = service;
        this.space = 255;
    }

    public CdiMemConfigReader(NodeID node, OlcbInterface iface, int space) {
        this.node = node;
        this.store = iface.getNodeStore();
        this.service = iface.getMemoryConfigurationService();
        this.space = space;
    }

    public void startLoadReader(ReaderAccess retval) {
        this.retval = retval;
        this.nextAddress = 0L;
        this.buf = new StringBuffer();
        this.nextRequest();
    }

    void nextRequest() {
        if (this.retval != null) {
            this.retval.progressNotify(this.buf.length(), -1L);
        }
        MemoryConfigurationService.McsReadHandler memo = new MemoryConfigurationService.McsReadHandler(){

            @Override
            public void handleFailure(int code) {
                logger.warning("Error reading CDI: " + Integer.toHexString(code));
                CdiMemConfigReader.this.done();
            }

            @Override
            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                if (data.length == 0) {
                    CdiMemConfigReader.this.done();
                    return;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == 0) {
                        CdiMemConfigReader.this.done();
                        return;
                    }
                    CdiMemConfigReader.this.buf.append((char)data[i]);
                }
                CdiMemConfigReader.this.nextAddress += 64L;
                CdiMemConfigReader.this.nextRequest();
            }
        };
        this.service.requestRead(this.node, this.space, this.nextAddress, 64, memo);
    }

    private void done() {
        if (this.retval != null) {
            this.retval.progressNotify(this.buf.length(), this.buf.length());
            logger.log(Level.FINE, "Retrieved XML: \n{0}", this.buf);
            this.retval.provideReader(new StringReader(new String(this.buf)));
        }
    }

    public static interface ReaderAccess {
        public void progressNotify(long var1, long var3);

        public void provideReader(Reader var1);
    }
}

