/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openlcb.Utilities;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.cdi.impl.ReadWriteAccess;
import org.openlcb.cdi.jdom.JdomCdiRep;
import org.openlcb.implementations.MemoryConfigurationService;

public class DemoReadWriteAccess
extends ReadWriteAccess {
    private static final Logger logger = Logger.getLogger(DemoReadWriteAccess.class.getName());

    @Override
    public void doWrite(long address, int space, byte[] data, MemoryConfigurationService.McsWriteHandler handler) {
        logger.log(Level.INFO, "Wrote {0} bytes", data.length);
        logger.log(Level.INFO, "write {0} {1}: {2}", new Object[]{address, space, Utilities.toHexDotsString(data)});
    }

    @Override
    public void doRead(long address, int space, int length, MemoryConfigurationService.McsReadHandler handler) {
        byte[] resp = new byte[length];
        for (int i = 0; i < resp.length; ++i) {
            resp[i] = (byte)((address + (long)i) % 91L + 32L);
        }
        handler.handleReadData(null, space, address, resp);
        logger.log(Level.INFO, "read {0} {1}", new Object[]{address, space});
    }

    public static ConfigRepresentation demoRepFromSample(Element root) {
        ConfigRepresentation rep = new ConfigRepresentation(new DemoReadWriteAccess(), new JdomCdiRep(root));
        return rep;
    }

    public static ConfigRepresentation demoRepFromFile(File file) {
        Element root = null;
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            Document doc = builder.build((InputStream)new BufferedInputStream(new FileInputStream(file)));
            root = doc.getRootElement();
        }
        catch (IOException | JDOMException e) {
            logger.log(Level.INFO, "While reading file: {0}", e);
        }
        return DemoReadWriteAccess.demoRepFromSample(root);
    }
}

