/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.DefaultPropertyListenerSupport;
import org.openlcb.EventID;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.Utilities;
import org.openlcb.cdi.CdiRep;
import org.openlcb.cdi.impl.MemorySpaceCache;
import org.openlcb.cdi.impl.ReadWriteAccess;
import org.openlcb.cdi.jdom.CdiMemConfigReader;
import org.openlcb.cdi.jdom.JdomCdiReader;
import org.openlcb.cdi.jdom.XmlHelper;

public class ConfigRepresentation
extends DefaultPropertyListenerSupport {
    public static final String UPDATE_STATE = "UPDATE_STATE";
    public static final String UPDATE_REP = "UPDATE_REP";
    public static final String UPDATE_CACHE_COMPLETE = "UPDATE_CACHE_COMPLETE";
    public static final String UPDATE_ENTRY_DATA = "UPDATE_ENTRY_DATA";
    public static final String UPDATE_WRITE_COMPLETE = "PENDING_WRITE_COMPLETE";
    private static final Logger logger = Logger.getLogger(ConfigRepresentation.class.getName());
    static final Charset UTF8 = Charset.forName("UTF8");
    private final OlcbInterface connection;
    private final NodeID remoteNodeID;
    private final ReadWriteAccess mockAccess;
    private CdiRep cdiRep;
    private String state = "Uninitialized";
    private CdiContainer root = null;
    private final Map<Integer, MemorySpaceCache> spaces = new TreeMap<Integer, MemorySpaceCache>();
    private final Map<String, CdiEntry> variables = new HashMap<String, CdiEntry>();
    private long lastProgress;
    int pendingCacheFills = 0;
    PropertyChangeListener prefillListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("UPDATE_LOADING_COMPLETE")) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (--ConfigRepresentation.this.pendingCacheFills == 0) {
                        ConfigRepresentation.this.firePropertyChange(ConfigRepresentation.UPDATE_CACHE_COMPLETE, null, null);
                        for (MemorySpaceCache sp : ConfigRepresentation.this.spaces.values()) {
                            sp.removePropertyChangeListener(ConfigRepresentation.this.prefillListener);
                        }
                    }
                }
            }
        }
    };

    public ConfigRepresentation(OlcbInterface connection, NodeID remoteNodeID) {
        this.connection = connection;
        this.remoteNodeID = remoteNodeID;
        this.mockAccess = null;
        this.triggerFetchCdi();
    }

    public ConfigRepresentation(ReadWriteAccess memoryAccess, CdiRep xmlRep) {
        this.connection = null;
        this.remoteNodeID = null;
        this.mockAccess = memoryAccess;
        this.cdiRep = xmlRep;
        this.parseRep();
    }

    @Nullable
    public OlcbInterface getConnection() {
        return this.connection;
    }

    @Nullable
    public NodeID getRemoteNodeID() {
        return this.remoteNodeID;
    }

    private void triggerFetchCdi() {
        new CdiMemConfigReader(this.remoteNodeID, this.connection, 255).startLoadReader(new CdiMemConfigReader.ReaderAccess(){

            @Override
            public void progressNotify(long bytesRead, long totalBytes) {
                ConfigRepresentation.this.lastProgress = new Date().getTime();
                if (totalBytes > 0L) {
                    ConfigRepresentation.this.setState(String.format("Loading: %.2f%% complete", (double)bytesRead * 100.0 / (double)totalBytes));
                } else {
                    ConfigRepresentation.this.setState(String.format("Loading: %d bytes complete", bytesRead));
                }
            }

            @Override
            public void provideReader(Reader r) {
                try {
                    ConfigRepresentation.this.cdiRep = new JdomCdiReader().getRep(XmlHelper.parseXmlFromReader(r));
                }
                catch (Exception e) {
                    String error = "Failed to parse CDI output: " + e.toString();
                    logger.warning(error);
                    ConfigRepresentation.this.setState(error);
                    return;
                }
                ConfigRepresentation.this.parseRep();
            }
        });
    }

    private void parseRep() {
        this.root = new Root(this.cdiRep);
        this.setState("Representation complete.");
        this.prefillCaches();
        this.firePropertyChange(UPDATE_REP, null, this.root);
    }

    public CdiRep getCdiRep() {
        return this.cdiRep;
    }

    private void prefillCaches() {
        this.variables.clear();
        this.visit(new Visitor(){

            @Override
            public void visitLeaf(final CdiEntry e) {
                ConfigRepresentation.this.variables.put(e.key, e);
                boolean nullTerminated = e.isNullTerminated();
                MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(e.space);
                cache.addRangeToCache(e.origin, e.origin + (long)e.size, nullTerminated);
                cache.addRangeListener(e.origin, e.origin + (long)e.size, nullTerminated, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        e.fireUpdate();
                    }
                });
            }
        });
        this.pendingCacheFills = this.spaces.size();
        for (MemorySpaceCache sp : this.spaces.values()) {
            sp.addPropertyChangeListener(this.prefillListener);
            sp.fillCache();
        }
    }

    public synchronized void reloadAll() {
        this.spaces.clear();
        this.prefillCaches();
    }

    public CdiContainer getRoot() {
        return this.root;
    }

    public String getRemoteNodeAsString() {
        if (this.remoteNodeID == null) {
            return "mock";
        }
        return this.remoteNodeID.toString();
    }

    @Nullable
    public CdiEntry getVariableForKey(@NonNull String key) {
        return this.variables.get(key);
    }

    private synchronized MemorySpaceCache getCacheForSpace(int space) {
        if (this.spaces.containsKey(space)) {
            return this.spaces.get(space);
        }
        MemorySpaceCache s = this.connection != null ? new MemorySpaceCache(this.connection, this.remoteNodeID, space) : new MemorySpaceCache(this.mockAccess, space);
        this.spaces.put(space, s);
        return s;
    }

    public void visit(Visitor v) {
        v.visitContainer(this.getRoot());
    }

    private long processGroup(String baseName, int segment, List<CdiRep.Item> items, List<CdiEntry> output, long origin) {
        if (items == null) {
            return 0L;
        }
        long base = origin;
        for (int i = 0; i < items.size(); ++i) {
            CdiRep.Item it = items.get(i);
            origin += (long)it.getOffset();
            CdiEntry entry = null;
            String entryName = it.getName();
            if (entryName == null || entryName.trim().isEmpty()) {
                entryName = "child" + it.getIndexInParent();
            }
            String name = baseName + "." + entryName;
            if (it instanceof CdiRep.Group) {
                entry = new GroupEntry(name, (CdiRep.Group)it, segment, origin);
            } else if (it instanceof CdiRep.IntegerRep) {
                entry = new IntegerEntry(name, (CdiRep.IntegerRep)it, segment, origin);
            } else if (it instanceof CdiRep.EventID) {
                entry = new EventEntry(name, (CdiRep.EventID)it, segment, origin);
            } else if (it instanceof CdiRep.StringRep) {
                entry = new StringEntry(name, (CdiRep.StringRep)it, segment, origin);
            } else {
                logger.log(Level.SEVERE, "could not process CDI entry type of {0}", it);
            }
            if (entry == null) continue;
            origin = entry.origin + (long)entry.size;
            output.add(entry);
        }
        return origin - base;
    }

    private void setState(String state) {
        String oldState = this.state;
        this.state = state;
        this.firePropertyChange(UPDATE_STATE, oldState, this.state);
    }

    public String getStatus() {
        return this.state;
    }

    public void restartIfNeeded() {
        if (this.root == null && this.lastProgress + 5000L < new Date().getTime()) {
            this.triggerFetchCdi();
        }
    }

    public class StringEntry
    extends CdiEntry {
        public CdiRep.StringRep rep;

        StringEntry(String name, CdiRep.StringRep rep, int segment, long origin) {
            this.key = name;
            this.space = segment;
            this.origin = origin;
            this.rep = rep;
            this.size = rep.getSize();
        }

        @Override
        public CdiRep.Item getCdiItem() {
            return this.rep;
        }

        @Override
        protected void updateVisibleValue() {
            this.lastVisibleValue = this.getValue();
        }

        @Override
        public boolean isNullTerminated() {
            return this.size > 64;
        }

        public String getValue() {
            int len;
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] b = cache.read(this.origin, this.size);
            if (b == null) {
                return null;
            }
            for (len = 0; len < b.length && b[len] != 0; ++len) {
            }
            byte[] rep = new byte[len];
            System.arraycopy(b, 0, rep, 0, len);
            String ret = new String(rep, UTF8);
            return ret;
        }

        public void setValue(String value) {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] f = value.getBytes(UTF8);
            byte[] b = new byte[Math.min(this.size, f.length + 1)];
            System.arraycopy(f, 0, b, 0, Math.min(f.length, b.length - 1));
            cache.write(this.origin, b, this);
        }
    }

    public class EventEntry
    extends CdiEntry {
        public CdiRep.EventID rep;

        EventEntry(String name, CdiRep.EventID rep, int segment, long origin) {
            this.key = name;
            this.space = segment;
            this.origin = origin;
            this.rep = rep;
            this.size = 8;
        }

        @Override
        public CdiRep.Item getCdiItem() {
            return this.rep;
        }

        @Override
        protected void updateVisibleValue() {
            EventID v = this.getValue();
            this.lastVisibleValue = v != null ? Utilities.toHexDotsString(v.getContents()) : "";
        }

        public EventID getValue() {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] b = cache.read(this.origin, this.size);
            if (b == null) {
                return null;
            }
            return new EventID(b);
        }

        public void setValue(EventID event) {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] b = event.getContents();
            if (b == null) {
                return;
            }
            cache.write(this.origin, b, this);
        }
    }

    public class IntegerEntry
    extends CdiEntry {
        public CdiRep.IntegerRep rep;

        IntegerEntry(String name, CdiRep.IntegerRep rep, int segment, long origin) {
            this.key = name;
            this.space = segment;
            this.origin = origin;
            this.rep = rep;
            this.size = rep.getSize();
        }

        @Override
        public CdiRep.Item getCdiItem() {
            return this.rep;
        }

        @Override
        protected void updateVisibleValue() {
            String value;
            this.lastVisibleValue = Long.toString(this.getValue());
            CdiRep.Map map = this.rep.getMap();
            if (map != null && map.getKeys().size() > 0 && (value = map.getEntry(this.lastVisibleValue)) != null) {
                this.lastVisibleValue = value;
            }
        }

        public long getValue() {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] b = cache.read(this.origin, this.size);
            if (b == null) {
                return 0L;
            }
            long ret = 0L;
            for (int i = 0; i < b.length; ++i) {
                ret <<= 8;
                int p = b[i] & 0xFF;
                ret |= (long)p;
            }
            return ret;
        }

        public void setValue(long value) {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            byte[] b = new byte[this.size];
            for (int i = this.size - 1; i >= 0; --i) {
                b[i] = (byte)(value & 0xFFL);
                value >>= 8;
            }
            cache.write(this.origin, b, this);
        }
    }

    public class GroupEntry
    extends GroupBase {
        GroupEntry(String baseName, CdiRep.Group group, int segment, long origin) {
            super(baseName, group, segment, origin);
            if (group.getReplication() <= 1) {
                this.size = (int)ConfigRepresentation.this.processGroup(baseName, segment, group.getItems(), this.items, this.origin);
            } else {
                this.size = 0;
                for (int i = 0; i < group.getReplication(); ++i) {
                    GroupRep e = new GroupRep(baseName + "(" + i + ")", group, segment, origin, i + 1);
                    this.items.add(e);
                    origin += (long)e.size;
                    this.size += e.size;
                }
            }
        }
    }

    public class GroupRep
    extends GroupBase {
        public int index;

        GroupRep(String name, CdiRep.Group group, int segment, long origin, int index) {
            super(name, group, segment, origin);
            this.size = (int)ConfigRepresentation.this.processGroup(name, segment, group.getItems(), this.items, origin);
            this.index = index;
        }
    }

    public class GroupBase
    extends CdiEntry
    implements CdiContainer {
        public final CdiRep.Group group;
        public final List<CdiEntry> items;

        public GroupBase(String name, CdiRep.Group group, int segment, long origin) {
            this.key = name;
            this.space = segment;
            this.origin = origin;
            this.group = group;
            this.items = new ArrayList<CdiEntry>();
        }

        @Override
        public List<CdiEntry> getEntries() {
            return this.items;
        }

        @Override
        public CdiRep.Item getCdiItem() {
            return this.group;
        }
    }

    public class SegmentEntry
    extends CdiEntry
    implements CdiContainer,
    CdiRep.Item {
        public final CdiRep.Segment segment;
        public final List<CdiEntry> items;

        public SegmentEntry(CdiRep.Segment segment) {
            this.segment = segment;
            this.items = new ArrayList<CdiEntry>();
            this.key = this.getName();
            if (this.key == null || this.key.trim().isEmpty()) {
                this.key = "seg" + segment.getIndexInParent();
            }
            this.origin = segment.getOrigin();
            this.space = segment.getSpace();
            this.size = (int)ConfigRepresentation.this.processGroup(this.key, this.space, segment.getItems(), this.items, this.origin);
        }

        @Override
        public List<CdiEntry> getEntries() {
            return this.items;
        }

        @Override
        public CdiRep.Item getCdiItem() {
            return this;
        }

        @Override
        public void reload() {
        }

        @Override
        public String getName() {
            return this.segment.getName();
        }

        @Override
        public String getDescription() {
            return this.segment.getDescription();
        }

        @Override
        public CdiRep.Map getMap() {
            return this.segment.getMap();
        }

        @Override
        public int getOffset() {
            return this.segment.getOrigin();
        }

        @Override
        public int getIndexInParent() {
            return this.segment.getIndexInParent();
        }
    }

    public class Root
    implements CdiContainer {
        public final List<CdiEntry> items = new ArrayList<CdiEntry>();
        public final CdiRep rep;

        public Root(CdiRep rep) {
            this.rep = rep;
            for (CdiRep.Segment e : rep.getSegments()) {
                this.items.add(new SegmentEntry(e));
            }
        }

        @Override
        public List<CdiEntry> getEntries() {
            return this.items;
        }
    }

    public abstract class CdiEntry
    extends DefaultPropertyListenerSupport {
        public int space;
        public long origin;
        public int size;
        public String key;
        public String lastVisibleValue = null;

        public abstract CdiRep.Item getCdiItem();

        protected void updateVisibleValue() {
        }

        public boolean isNullTerminated() {
            return false;
        }

        public void fireUpdate() {
            this.updateVisibleValue();
            this.firePropertyChange(ConfigRepresentation.UPDATE_ENTRY_DATA, null, null);
        }

        public void fireWriteComplete() {
            this.firePropertyChange(ConfigRepresentation.UPDATE_WRITE_COMPLETE, null, null);
        }

        public void reload() {
            MemorySpaceCache cache = ConfigRepresentation.this.getCacheForSpace(this.space);
            cache.reload(this.origin, this.size, this.isNullTerminated());
        }
    }

    public static class Visitor {
        public void visitEntry(CdiEntry e) {
            if (e instanceof StringEntry) {
                this.visitString((StringEntry)e);
            } else if (e instanceof IntegerEntry) {
                this.visitInt((IntegerEntry)e);
            } else if (e instanceof EventEntry) {
                this.visitEvent((EventEntry)e);
            } else if (e instanceof GroupRep) {
                this.visitGroupRep((GroupRep)e);
            } else if (e instanceof GroupEntry) {
                this.visitGroup((GroupEntry)e);
            } else if (e instanceof SegmentEntry) {
                this.visitSegment((SegmentEntry)e);
            } else if (e instanceof CdiContainer) {
                this.visitContainer((CdiContainer)((Object)e));
            } else {
                logger.warning("Don't know how to visit entry: " + e.getClass().getName());
            }
        }

        public void visitLeaf(CdiEntry e) {
        }

        public void visitString(StringEntry e) {
            this.visitLeaf(e);
        }

        public void visitInt(IntegerEntry e) {
            this.visitLeaf(e);
        }

        public void visitEvent(EventEntry e) {
            this.visitLeaf(e);
        }

        public void visitGroupRep(GroupRep e) {
            this.visitContainer(e);
        }

        public void visitGroup(GroupEntry e) {
            this.visitContainer(e);
        }

        public void visitSegment(SegmentEntry e) {
            this.visitContainer(e);
        }

        public void visitContainer(CdiContainer c) {
            for (CdiEntry e : c.getEntries()) {
                this.visitEntry(e);
            }
        }
    }

    public static interface CdiContainer {
        public List<CdiEntry> getEntries();
    }
}

