/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.cmd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.can.impl.OlcbConnection;
import org.openlcb.cdi.cmd.Util;
import org.openlcb.cdi.impl.ConfigRepresentation;

public class BackupConfig {
    public static void writeEntry(BufferedWriter outFile, String key, String value) {
        try {
            outFile.write(Util.escapeString(key));
            outFile.write(61);
            outFile.write(Util.escapeString(value));
            outFile.write(10);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
    }

    public static void writeConfigToFile(String fileName, ConfigRepresentation repr) throws IOException {
        BufferedWriter outFile = null;
        final BufferedWriter finalOutFile = outFile = Files.newBufferedWriter(Paths.get(fileName, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        repr.visit(new ConfigRepresentation.Visitor(){

            @Override
            public void visitString(ConfigRepresentation.StringEntry e) {
                BackupConfig.writeEntry(finalOutFile, e.key, e.getValue());
            }

            @Override
            public void visitInt(ConfigRepresentation.IntegerEntry e) {
                BackupConfig.writeEntry(finalOutFile, e.key, Long.toString(e.getValue()));
            }

            @Override
            public void visitEvent(ConfigRepresentation.EventEntry e) {
                BackupConfig.writeEntry(finalOutFile, e.key, Utilities.toHexDotsString(e.getValue().getContents()));
            }
        });
        outFile.close();
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            BackupConfig.usage();
            return;
        }
        System.out.println("arg0: " + args[0]);
        NodeID localNode = new NodeID(args[0]);
        String host = args[1];
        int port = Integer.parseInt(args[2]);
        NodeID remoteNode = new NodeID(args[3]);
        String dstFile = args[4];
        OlcbConnection connection = Util.connect(localNode, host, port);
        System.out.println("Fetching CDI.");
        ConfigRepresentation repr = connection.getConfigForNode(remoteNode);
        Util.waitForPropertyChange(repr, "UPDATE_REP");
        System.out.println("CDI fetch done. Waiting for caches.");
        Util.waitForPropertyChange(repr, "UPDATE_CACHE_COMPLETE");
        System.out.println("Caches complete. Writing variables.");
        try {
            BackupConfig.writeConfigToFile(dstFile, repr);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Done.");
        System.exit(0);
    }

    private static void usage() {
        String usageString = "usage: saveconfig local_node_id hub_host hub_port dst_node_id dst_filename\n";
        System.err.print(usageString);
    }
}

