/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanFrameListener;
import org.openlcb.implementations.DatagramUtils;

public class GridConnectInput {
    private static final Logger logger = Logger.getLogger(GridConnectInput.class.getName());
    private boolean isExtended;
    private int header;
    private boolean isRtr;
    private ArrayList<Byte> data = new ArrayList();
    private BufferedReader input;
    private CanFrameListener listener;
    private final Runnable onError;

    public GridConnectInput(BufferedReader input, CanFrameListener listener, Runnable onError) {
        this.input = input;
        this.listener = listener;
        this.onError = onError;
        new Thread("openlcb-gc-input"){

            @Override
            public void run() {
                GridConnectInput.this.threadBody();
            }
        }.start();
    }

    private void threadBody() {
        try {
            while (true) {
                int c;
                if (this.input.read() != 58) {
                    continue;
                }
                int typeChar = this.input.read();
                if (typeChar == 88) {
                    this.isExtended = true;
                } else if (typeChar == 83) {
                    this.isExtended = false;
                } else {
                    logger.fine("Unknown gridconnect type character: " + typeChar);
                }
                this.header = 0;
                while (true) {
                    this.input.mark(2);
                    c = this.input.read();
                    int dvalue = Character.digit(c, 16);
                    if (dvalue < 0) break;
                    this.header <<= 4;
                    this.header |= dvalue;
                }
                if (c == 78) {
                    this.isRtr = false;
                } else if (c == 82) {
                    this.isRtr = true;
                } else {
                    logger.fine("Unknown gridconnect remote character: " + c);
                    this.input.reset();
                    continue;
                }
                this.data.clear();
                while (true) {
                    this.input.mark(2);
                    byte value = 0;
                    c = this.input.read();
                    int dvalue = Character.digit(c, 16);
                    if (dvalue < 0) break;
                    value = (byte)(dvalue << 4);
                    this.input.mark(2);
                    c = this.input.read();
                    dvalue = Character.digit(c, 16);
                    if (dvalue < 0) break;
                    value = (byte)(value | dvalue & 0xF);
                    this.data.add(value);
                }
                if (c == 59) {
                    RawCanFrame f = new RawCanFrame(this.isExtended, this.header, this.isRtr, this.data);
                    this.listener.send(f);
                    continue;
                }
                logger.fine("unexpected gridconnect payload character: " + c);
                this.input.reset();
            }
        }
        catch (IOException e) {
            logger.info("Error reading from gridconnect port " + e.toString());
            try {
                this.input.close();
            }
            catch (IOException e1) {
                logger.fine("Error closing from gridconnect port " + e1.toString());
            }
            if (this.onError != null) {
                this.onError.run();
            }
            return;
        }
    }

    class RawCanFrame
    implements CanFrame {
        private boolean isExtended;
        private boolean isRtr;
        private int header;
        private int len;
        private byte[] data;

        public RawCanFrame(boolean isExtended, int header, boolean isRtr, ArrayList<Byte> data) {
            this.isExtended = isExtended;
            this.header = header;
            this.isRtr = isRtr;
            this.len = data.size();
            this.data = new byte[this.len];
            for (int i = 0; i < this.len; ++i) {
                this.data[i] = data.get(i);
            }
        }

        @Override
        public int getHeader() {
            return this.header;
        }

        @Override
        public boolean isExtended() {
            return this.isExtended;
        }

        @Override
        public boolean isRtr() {
            return this.isRtr;
        }

        @Override
        public int getNumDataElements() {
            return this.len;
        }

        @Override
        public int getElement(int n) {
            return DatagramUtils.byteToInt(this.data[n]);
        }

        @Override
        public long bodyAsLong() {
            long retval = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                retval = retval << 8 | (long)(this.data[i] & 0xFF);
            }
            return retval;
        }

        @Override
        public long dataAsLong() {
            long retval = 0L;
            for (int i = 2; i < this.data.length; ++i) {
                retval = retval << 8 | (long)(this.data[i] & 0xFF);
            }
            return retval;
        }

        @Override
        public byte[] getData() {
            byte[] b = new byte[this.len];
            System.arraycopy(this.data, 0, b, 0, this.len);
            return b;
        }
    }
}

