/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.ConsumerRangeIdentifiedMessage;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.DatagramRejectedMessage;
import org.openlcb.EventID;
import org.openlcb.EventState;
import org.openlcb.IdentifyConsumersMessage;
import org.openlcb.IdentifyEventsAddressedMessage;
import org.openlcb.IdentifyEventsGlobalMessage;
import org.openlcb.IdentifyProducersMessage;
import org.openlcb.InitializationCompleteMessage;
import org.openlcb.LearnEventMessage;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.OptionalIntRejectedMessage;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.ProducerRangeIdentifiedMessage;
import org.openlcb.ProtocolIdentificationReplyMessage;
import org.openlcb.ProtocolIdentificationRequestMessage;
import org.openlcb.SimpleNodeIdentInfoReplyMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;
import org.openlcb.StreamDataCompleteMessage;
import org.openlcb.StreamDataProceedMessage;
import org.openlcb.StreamDataSendMessage;
import org.openlcb.StreamInitiateReplyMessage;
import org.openlcb.StreamInitiateRequestMessage;
import org.openlcb.Utilities;
import org.openlcb.VerifiedNodeIDNumberMessage;
import org.openlcb.VerifyNodeIDNumberMessage;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.OpenLcbCanFrame;
import org.openlcb.implementations.DatagramUtils;
import org.openlcb.messages.TractionControlReplyMessage;
import org.openlcb.messages.TractionControlRequestMessage;
import org.openlcb.messages.TractionProxyReplyMessage;
import org.openlcb.messages.TractionProxyRequestMessage;

public class MessageBuilder {
    private static final Logger logger = Logger.getLogger(MessageBuilder.class.getName());
    AliasMap map;
    HashMap<NodeID, List<Integer>> datagramData = new HashMap();
    HashMap<NodeID, List<Integer>> streamData = new HashMap();
    HashMap<Integer, AccumulationMemo> accumulations = new HashMap();

    public MessageBuilder(AliasMap map) {
        this.map = map;
    }

    public List<Message> processFrame(CanFrame f) {
        if ((f.getHeader() & 0x8000000) != 0x8000000) {
            return null;
        }
        int format = (f.getHeader() & 0x7000000) >> 24;
        switch (format) {
            case 0: {
                return this.processFormat0(f);
            }
            case 1: {
                return this.processFormat1(f);
            }
            case 2: {
                return this.processFormat2(f);
            }
            case 3: {
                return this.processFormat3(f);
            }
            case 4: {
                return this.processFormat4(f);
            }
            case 5: {
                return this.processFormat5(f);
            }
            case 6: {
                return this.processFormat6(f);
            }
            case 7: {
                return this.processFormat7(f);
            }
        }
        return null;
    }

    int getSourceID(CanFrame f) {
        return f.getHeader() & 0xFFF;
    }

    int getMTI(CanFrame f) {
        return (f.getHeader() & 0xFFF000) >> 12;
    }

    EventID getEventID(CanFrame f) {
        return new EventID(f.getData());
    }

    List<Message> processFormat0(CanFrame f) {
        return null;
    }

    List<Message> processFormat1(CanFrame f) {
        MessageTypeIdentifier value;
        ArrayList<Message> retlist = new ArrayList<Message>();
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        NodeID dest = null;
        int mti = this.getMTI(f);
        byte[] data = f.getData();
        byte[] content = null;
        if ((mti & 8) != 0 && f.getNumDataElements() >= 2) {
            dest = this.map.getNodeID((f.getElement(0) << 8) + (f.getElement(1) & 0xFF) & 0xFFF);
            AccumulationMemo mnew = new AccumulationMemo(f.getHeader(), source, dest, data);
            AccumulationMemo mold = this.accumulations.get(f.getHeader());
            if (mold == null) {
                this.accumulations.put(f.getHeader(), mnew);
                mold = mnew;
            } else {
                byte[] newdata = new byte[mold.data.length + mnew.data.length - 2];
                System.arraycopy(mold.data, 0, newdata, 0, mold.data.length);
                System.arraycopy(mnew.data, 2, newdata, mold.data.length, mnew.data.length - 2);
                mold.data = newdata;
            }
            if ((f.getElement(0) & 0x10) != 0) {
                return retlist;
            }
            data = mold.data;
            this.accumulations.remove(f.getHeader());
            content = new byte[data.length - 2];
            System.arraycopy(data, 2, content, 0, content.length);
        }
        if ((value = MessageTypeIdentifier.get(mti)) == null) {
            String mtiString = "000" + Integer.toHexString(mti).toUpperCase();
            mtiString = mtiString.substring(mtiString.length() - 3);
            logger.log(Level.SEVERE, " failed to parse MTI 0x{0}", mtiString);
            return retlist;
        }
        switch (value) {
            case InitializationComplete: {
                retlist.add(new InitializationCompleteMessage(source));
                return retlist;
            }
            case VerifyNodeIdGlobal: {
                if (data.length >= 6) {
                    NodeID node = new NodeID(data);
                    retlist.add(new VerifyNodeIDNumberMessage(source, node));
                } else {
                    retlist.add(new VerifyNodeIDNumberMessage(source));
                }
                return retlist;
            }
            case VerifiedNodeId: {
                retlist.add(new VerifiedNodeIDNumberMessage(source));
                return retlist;
            }
            case OptionalInteractionRejected: {
                int d2 = data.length >= 3 ? f.getElement(2) : 0;
                int d3 = data.length >= 4 ? f.getElement(3) : 0;
                int d4 = data.length >= 5 ? f.getElement(4) : 0;
                int d5 = data.length >= 6 ? f.getElement(5) : 0;
                int retmti = (d2 & 0xFF) << 8 | d3 & 0xFF;
                int code = (d4 & 0xFF) << 8 | d5 & 0xFF;
                retlist.add(new OptionalIntRejectedMessage(source, dest, retmti, code));
                return retlist;
            }
            case ProtocolSupportInquiry: {
                retlist.add(new ProtocolIdentificationRequestMessage(source, dest));
                return retlist;
            }
            case ProtocolSupportReply: {
                retlist.add(new ProtocolIdentificationReplyMessage(source, dest, f.dataAsLong()));
                return retlist;
            }
            case TractionControlRequest: {
                retlist.add(new TractionControlRequestMessage(source, dest, content));
                return retlist;
            }
            case TractionControlReply: {
                retlist.add(new TractionControlReplyMessage(source, dest, content));
                return retlist;
            }
            case TractionProxyRequest: {
                retlist.add(new TractionProxyRequestMessage(source, dest, content));
                return retlist;
            }
            case TractionProxyReply: {
                retlist.add(new TractionProxyReplyMessage(source, dest, content));
                return retlist;
            }
            case IdentifyConsumer: {
                retlist.add(new IdentifyConsumersMessage(source, this.getEventID(f)));
                return retlist;
            }
            case ConsumerRangeIdentified: {
                retlist.add(new ConsumerRangeIdentifiedMessage(source, this.getEventID(f)));
                return retlist;
            }
            case ConsumerIdentifiedUnknown: {
                retlist.add(new ConsumerIdentifiedMessage(source, this.getEventID(f), EventState.Unknown));
                return retlist;
            }
            case ConsumerIdentifiedValid: {
                retlist.add(new ConsumerIdentifiedMessage(source, this.getEventID(f), EventState.Valid));
                return retlist;
            }
            case ConsumerIdentifiedInvalid: {
                retlist.add(new ConsumerIdentifiedMessage(source, this.getEventID(f), EventState.Invalid));
                return retlist;
            }
            case IdentifyProducer: {
                retlist.add(new IdentifyProducersMessage(source, this.getEventID(f)));
                return retlist;
            }
            case ProducerRangeIdentified: {
                retlist.add(new ProducerRangeIdentifiedMessage(source, this.getEventID(f)));
                return retlist;
            }
            case ProducerIdentifiedUnknown: {
                retlist.add(new ProducerIdentifiedMessage(source, this.getEventID(f), EventState.Unknown));
                return retlist;
            }
            case ProducerIdentifiedValid: {
                retlist.add(new ProducerIdentifiedMessage(source, this.getEventID(f), EventState.Valid));
                return retlist;
            }
            case ProducerIdentifiedInvalid: {
                retlist.add(new ProducerIdentifiedMessage(source, this.getEventID(f), EventState.Invalid));
                return retlist;
            }
            case ProducerConsumerEventReport: {
                retlist.add(new ProducerConsumerEventReportMessage(source, this.getEventID(f)));
                return retlist;
            }
            case IdentifyEventsAddressed: {
                retlist.add(new IdentifyEventsAddressedMessage(source, dest));
                return retlist;
            }
            case IdentifyEventsGlobal: {
                retlist.add(new IdentifyEventsGlobalMessage(source));
                return retlist;
            }
            case LearnEvent: {
                retlist.add(new LearnEventMessage(source, this.getEventID(f)));
                return retlist;
            }
            case SimpleNodeIdentInfoRequest: {
                retlist.add(new SimpleNodeIdentInfoRequestMessage(source, dest));
                return retlist;
            }
            case SimpleNodeIdentInfoReply: {
                retlist.add(new SimpleNodeIdentInfoReplyMessage(source, dest, content));
                return retlist;
            }
            case DatagramReceivedOK: {
                if (content != null && content.length > 0) {
                    retlist.add(new DatagramAcknowledgedMessage(source, dest, DatagramUtils.byteToInt((byte)content[0])));
                } else {
                    retlist.add(new DatagramAcknowledgedMessage(source, dest));
                }
                return retlist;
            }
            case DatagramRejected: {
                retlist.add(new DatagramRejectedMessage(source, dest, (int)f.dataAsLong()));
                return retlist;
            }
            case StreamInitiateRequest: {
                retlist.add(new StreamInitiateRequestMessage(source, dest, Utilities.NetworkToHostUint16(content, 2), (byte)content[4], content.length > 5 ? content[5] : (byte)-1));
                return retlist;
            }
            case StreamInitiateReply: {
                retlist.add(new StreamInitiateReplyMessage(source, dest, Utilities.NetworkToHostUint16(content, 0), (byte)content[4], (byte)content[5]));
                return retlist;
            }
            case StreamDataProceed: {
                retlist.add(new StreamDataProceedMessage(source, dest, (byte)content[2], (byte)content[3]));
                return retlist;
            }
            case StreamDataComplete: {
                retlist.add(new StreamDataCompleteMessage(source, dest, content.length > 2 ? content[2] : (byte)-1, content.length > 3 ? content[3] : (byte)-1));
                return retlist;
            }
        }
        logger.warning(String.format(" received unhandled MTI 0x%03X: %s", mti, value.toString()));
        return null;
    }

    List<Message> processFormat2(CanFrame f) {
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        List<Integer> list = this.datagramData.get(source);
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        for (int i = 0; i < f.getNumDataElements(); ++i) {
            list.add(f.getElement(i));
        }
        int[] data = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = list.get(i);
        }
        ArrayList<Message> retlist = new ArrayList<Message>();
        NodeID dest = this.map.getNodeID((f.getHeader() & 0xFFF000) >> 12);
        retlist.add(new DatagramMessage(source, dest, data));
        return retlist;
    }

    List<Message> processFormat3(CanFrame f) {
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        List<Integer> list = this.datagramData.get(source);
        if (list == null) {
            list = new ArrayList<Integer>();
            this.datagramData.put(source, list);
        }
        for (int i = 0; i < f.getNumDataElements(); ++i) {
            list.add(f.getElement(i));
        }
        return null;
    }

    List<Message> processFormat4(CanFrame f) {
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        List<Integer> list = this.datagramData.get(source);
        if (list == null) {
            list = new ArrayList<Integer>();
            this.datagramData.put(source, list);
        }
        for (int i = 0; i < f.getNumDataElements(); ++i) {
            list.add(f.getElement(i));
        }
        return null;
    }

    List<Message> processFormat5(CanFrame f) {
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        List<Integer> list = this.datagramData.get(source);
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        for (int i = 0; i < f.getNumDataElements(); ++i) {
            list.add(f.getElement(i));
        }
        this.datagramData.put(source, null);
        int[] data = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = list.get(i);
        }
        ArrayList<Message> retlist = new ArrayList<Message>();
        NodeID dest = this.map.getNodeID((f.getHeader() & 0xFFF000) >> 12);
        retlist.add(new DatagramMessage(source, dest, data));
        return retlist;
    }

    List<Message> processFormat6(CanFrame f) {
        return null;
    }

    List<Message> processFormat7(CanFrame f) {
        int n;
        NodeID source = this.map.getNodeID(this.getSourceID(f));
        int bufSize = 64;
        int destID = f.getElement(0);
        List<Integer> list = this.streamData.get(source);
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        if ((n = Math.min(bufSize, f.getNumDataElements())) < bufSize) {
            for (int i = 1; i < f.getNumDataElements(); ++i) {
                list.add(f.getElement(i));
            }
            return null;
        }
        for (int i = 1; i < n; ++i) {
            list.add(f.getElement(i));
        }
        int[] data = new int[list.size()];
        for (int i = 0; i < bufSize; ++i) {
            data[i] = list.get(i);
        }
        ArrayList<Message> retlist = new ArrayList<Message>();
        NodeID dest = this.map.getNodeID((f.getHeader() & 0xFFF000) >> 12);
        retlist.add(new StreamDataSendMessage(source, dest, (byte)destID, data));
        list = new ArrayList<Integer>();
        for (int i = n; i < f.getNumDataElements(); ++i) {
            list.add(f.getElement(i));
        }
        return retlist;
    }

    public List<OpenLcbCanFrame> processMessage(Message msg) {
        FrameBuilder f = new FrameBuilder();
        return f.convert(msg);
    }

    private class FrameBuilder
    extends MessageDecoder {
        List<OpenLcbCanFrame> retlist;

        private FrameBuilder() {
        }

        @Override
        protected void defaultHandler(Message msg, Connection sender) {
            if (!(msg instanceof AddressedPayloadMessage)) {
                throw new NoSuchMethodError("no handler for Message: " + msg.toString());
            }
            this.handleAddressedPayloadMessage((AddressedPayloadMessage)msg, sender);
        }

        List<OpenLcbCanFrame> convert(Message msg) {
            this.retlist = new ArrayList<OpenLcbCanFrame>();
            this.put(msg, null);
            return this.retlist;
        }

        private void handleAddressedPayloadMessage(AddressedPayloadMessage msg, Connection sender) {
            byte[] payload = msg.getPayload();
            if (payload == null) {
                payload = new byte[]{};
            }
            for (int i = 0; i < Math.max(1, payload.length); i += 6) {
                OpenLcbCanFrame f = new OpenLcbCanFrame(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
                f.setOpenLcbMTI(msg.getEMTI().mti());
                int thislen = Math.min(6, payload.length - i);
                byte[] data = new byte[thislen + 2];
                System.arraycopy(payload, i, data, 2, thislen);
                f.setData(data);
                f.setDestAlias(MessageBuilder.this.map.getAlias(msg.getDestNodeID()));
                f.setContinuation(i == 0, i + 6 >= payload.length);
                this.retlist.add(f);
            }
        }

        @Override
        public void handleInitializationComplete(InitializationCompleteMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setInitializationComplete(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()), msg.getSourceNodeID());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            this.retlist.add(f);
        }

        @Override
        public void handleVerifiedNodeIDNumber(VerifiedNodeIDNumberMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setVerifiedNID(msg.getSourceNodeID());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            this.retlist.add(f);
        }

        @Override
        public void handleVerifyNodeIDNumber(VerifyNodeIDNumberMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setVerifyNID(msg.getSourceNodeID());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            if (msg.getContent() != null) {
                f.setData(msg.getContent().getContents());
            }
            this.retlist.add(f);
        }

        @Override
        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setPCEventReport(msg.getEventID());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            this.retlist.add(f);
        }

        @Override
        public void handleIdentifyConsumers(IdentifyConsumersMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(MessageTypeIdentifier.IdentifyConsumer.mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleConsumerIdentified(ConsumerIdentifiedMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(msg.getEventState().getConsumerIdentifierMti().mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleConsumerRangeIdentified(ConsumerRangeIdentifiedMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(MessageTypeIdentifier.ConsumerRangeIdentified.mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleIdentifyProducers(IdentifyProducersMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(MessageTypeIdentifier.IdentifyProducer.mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleProducerRangeIdentified(ProducerRangeIdentifiedMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(MessageTypeIdentifier.ProducerRangeIdentified.mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            f.setOpenLcbMTI(msg.getEventState().getProducerIdentifierMti().mti());
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.loadFromEid(msg.getEventID());
            this.retlist.add(f);
        }

        @Override
        public void handleIdentifyEventsAddressed(IdentifyEventsAddressedMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(0);
            if (msg.getDestNodeID() != null) {
                f.setOpenLcbMTI(MessageTypeIdentifier.IdentifyEventsAddressed.mti());
                f.setDestAlias(MessageBuilder.this.map.getAlias(msg.getDestNodeID()));
            } else {
                f.setOpenLcbMTI(MessageTypeIdentifier.IdentifyEventsGlobal.mti());
            }
            f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            this.retlist.add(f);
        }

        @Override
        public void handleIdentifyEventsGlobal(IdentifyEventsGlobalMessage msg, Connection sender) {
            OpenLcbCanFrame f = new OpenLcbCanFrame(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
            f.setOpenLcbMTI(MessageTypeIdentifier.IdentifyEventsGlobal.mti());
            this.retlist.add(f);
        }

        @Override
        public void handleLearnEvent(LearnEventMessage msg, Connection sender) {
            this.defaultHandler(msg, sender);
        }

        @Override
        public void handleDatagram(DatagramMessage msg, Connection sender) {
            int size;
            int remains = msg.getData().length;
            int j = 0;
            boolean first = true;
            do {
                size = Math.min(8, remains);
                int[] data = new int[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = msg.getData()[j++];
                }
                OpenLcbCanFrame f = new OpenLcbCanFrame(0);
                f.setDatagram(data, MessageBuilder.this.map.getAlias(msg.getDestNodeID()), first, remains <= 8);
                f.setSourceAlias(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
                this.retlist.add(f);
                first = false;
            } while ((remains -= size) > 0);
        }

        @Override
        public void handleStreamDataSend(StreamDataSendMessage msg, Connection sender) {
            int size;
            int remains = msg.getData().length;
            int j = 0;
            do {
                size = Math.min(7, remains);
                byte[] data = new byte[size + 1];
                data[0] = msg.getDestinationStreamID();
                for (int i = 0; i < size; ++i) {
                    data[i + 1] = (byte)msg.getData()[j++];
                }
                OpenLcbCanFrame f = new OpenLcbCanFrame(MessageBuilder.this.map.getAlias(msg.getSourceNodeID()));
                f.setStream(data, MessageBuilder.this.map.getAlias(msg.getDestNodeID()));
                this.retlist.add(f);
            } while ((remains -= size) > 0);
        }
    }

    class AccumulationMemo {
        long header;
        NodeID source;
        NodeID dest;
        byte[] data;

        public AccumulationMemo(long header, NodeID source, NodeID dest, byte[] data) {
            this.header = header;
            this.source = source;
            this.dest = dest;
            this.data = data;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccumulationMemo)) {
                return false;
            }
            AccumulationMemo other = (AccumulationMemo)obj;
            if (this.header != other.header) {
                return false;
            }
            if (!this.source.equals(other.source)) {
                return false;
            }
            return this.dest.equals(other.dest);
        }

        public int hashCode() {
            return (int)(this.header + (long)this.dest.hashCode() + (long)this.source.hashCode());
        }
    }
}

