/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.HashMap;
import org.openlcb.NodeID;
import org.openlcb.can.OpenLcbCanFrame;

public class AliasMap {
    HashMap<NodeID, Integer> iMap = new HashMap();
    HashMap<Integer, NodeID> nMap = new HashMap();

    public void processFrame(OpenLcbCanFrame f) {
        if (f.isInitializationComplete() || f.isVerifiedNID() || f.isAliasMapDefinition()) {
            Integer alias = f.getSourceAlias();
            NodeID nid = f.getNodeID();
            this.insert(alias, nid);
        } else if (f.isAliasMapReset()) {
            Integer alias = f.getSourceAlias();
            this.remove(alias);
        }
    }

    public void insert(int alias, NodeID nid) {
        this.nMap.put(alias, nid);
        this.iMap.put(nid, alias);
    }

    public void remove(int alias) {
        NodeID nid = this.getNodeID(alias);
        if (nid == null) {
            return;
        }
        this.nMap.remove(alias);
        this.iMap.remove(nid);
    }

    public NodeID getNodeID(int alias) {
        NodeID retVal = this.nMap.get(alias);
        if (retVal != null) {
            return retVal;
        }
        return new NodeID();
    }

    public int getAlias(NodeID nid) {
        Integer r = this.iMap.get(nid);
        if (r == null) {
            return -1;
        }
        return r;
    }
}

