/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@Immutable
@ThreadSafe
public class Utilities {
    @CheckReturnValue
    @NonNull
    public static String toHexPair(int i) {
        String retval = "00" + Integer.toHexString(i).toUpperCase();
        return retval.substring(retval.length() - 2);
    }

    @CheckReturnValue
    @NonNull
    public static String toHexSpaceString(int[] array) {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (!first) {
                buff.append(" ");
            }
            first = false;
            buff.append(Utilities.toHexPair(array[i]));
        }
        String retval = new String(buff);
        return retval;
    }

    @CheckReturnValue
    @NonNull
    public static String toHexSpaceString(byte[] array) {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (!first) {
                buff.append(" ");
            }
            first = false;
            buff.append(Utilities.toHexPair(array[i]));
        }
        String retval = new String(buff);
        return retval;
    }

    @CheckReturnValue
    @NonNull
    public static String toHexDotsString(int[] array) {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (!first) {
                buff.append(".");
            }
            first = false;
            buff.append(Utilities.toHexPair(array[i]));
        }
        String retval = new String(buff);
        return retval;
    }

    @CheckReturnValue
    @NonNull
    public static String toHexDotsString(byte[] array) {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (!first) {
                buff.append(".");
            }
            first = false;
            buff.append(Utilities.toHexPair(array[i]));
        }
        String retval = new String(buff);
        return retval;
    }

    public static byte[] bytesFromHexString(String s) {
        String ts = s.replace(".", " ") + "  ";
        int len = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (ts.charAt(i) == ' ') continue;
            if (ts.charAt(i + 1) != ' ') {
                ++i;
                ++len;
                continue;
            }
            ++len;
        }
        byte[] b = new byte[len];
        int saveAt = 0;
        for (int i = 0; i < s.length(); ++i) {
            String v;
            if (ts.charAt(i) == ' ') continue;
            if (ts.charAt(i + 1) != ' ') {
                v = "" + ts.charAt(i) + ts.charAt(i + 1);
                b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
                ++i;
                ++saveAt;
                continue;
            }
            v = "" + ts.charAt(i);
            b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
            ++saveAt;
        }
        return b;
    }

    public static int NetworkToHostUint8(byte[] arr, int offset) {
        if (arr == null || arr.length < offset) {
            return 0;
        }
        int r = arr[offset];
        return r &= 0xFF;
    }

    public static void HostToNetworkUint8(byte[] arr, int offset, int value) {
        arr[offset] = (byte)(value & 0xFF);
    }

    public static int NetworkToHostUint16(byte[] arr, int offset) {
        if (arr == null || arr.length < offset + 1) {
            return 0;
        }
        return (arr[offset] & 0xFF) << 8 | arr[offset + 1] & 0xFF;
    }

    public static void HostToNetworkUint16(byte[] arr, int offset, int value) {
        arr[offset] = (byte)(value >> 8 & 0xFF);
        arr[offset + 1] = (byte)(value & 0xFF);
    }

    public static long NetworkToHostUint32(byte[] arr, int offset) {
        if (arr == null || arr.length < offset + 3) {
            return 0L;
        }
        long ret = 0L;
        ret |= (long)(arr[offset] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 1] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 2] & 0xFF);
        ret <<= 8;
        return ret |= (long)(arr[offset + 3] & 0xFF);
    }

    public static void HostToNetworkUint32(byte[] arr, int offset, long value) {
        arr[offset] = (byte)(value >> 24 & 0xFFL);
        arr[offset + 1] = (byte)(value >> 16 & 0xFFL);
        arr[offset + 2] = (byte)(value >> 8 & 0xFFL);
        arr[offset + 3] = (byte)(value & 0xFFL);
    }

    public static long NetworkToHostUint48(byte[] arr, int offset) {
        if (arr == null || arr.length < offset + 5) {
            return 0L;
        }
        long ret = 0L;
        ret |= (long)(arr[offset] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 1] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 2] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 3] & 0xFF);
        ret <<= 8;
        ret |= (long)(arr[offset + 4] & 0xFF);
        ret <<= 8;
        return ret |= (long)(arr[offset + 5] & 0xFF);
    }

    public static void HostToNetworkUint48(byte[] arr, int offset, long value) {
        arr[offset] = (byte)(value >> 40 & 0xFFL);
        arr[offset + 1] = (byte)(value >> 32 & 0xFFL);
        arr[offset + 2] = (byte)(value >> 24 & 0xFFL);
        arr[offset + 3] = (byte)(value >> 16 & 0xFFL);
        arr[offset + 4] = (byte)(value >> 8 & 0xFFL);
        arr[offset + 5] = (byte)(value & 0xFFL);
    }
}

