/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import java.util.ArrayList;
import java.util.List;
import org.openlcb.Connection;
import org.openlcb.NodeID;
import org.openlcb.ProtocolIdentificationReplyMessage;
import org.openlcb.ProtocolIdentificationRequestMessage;

public class ProtocolIdentification {
    long value = 0L;
    NodeID source;
    NodeID dest;

    public ProtocolIdentification(NodeID me, ProtocolIdentificationReplyMessage msg) {
        this.source = me;
        this.dest = msg.getSourceNodeID();
        this.value = msg.getValue();
    }

    public ProtocolIdentification(NodeID source, NodeID dest) {
        this.source = source;
        this.dest = dest;
        this.value = 0L;
    }

    void start(Connection connection) {
        if (this.dest == null) {
            throw new AssertionError((Object)"PIP dest==null");
        }
        if (this.source == null) {
            throw new AssertionError((Object)"PIP src = null");
        }
        connection.put(new ProtocolIdentificationRequestMessage(this.source, this.dest), null);
    }

    public long getValue() {
        return this.value;
    }

    public List<Protocol> getProtocols() {
        return Protocol.decode(this.value);
    }

    public List<String> getProtocolNames() {
        return Protocol.decodeNames(this.value);
    }

    boolean hasProtocol(Protocol protocol) {
        return protocol.supports(this.value);
    }

    public static enum Protocol {
        ProtocolIdentification(0x800000000000L, "ProtocolIdentification"),
        Datagram(0x400000000000L, "Datagram"),
        Stream(0x200000000000L, "Stream"),
        Configuration(0x100000000000L, "Configuration"),
        Reservation(0x80000000000L, "Reservation"),
        ProducerConsumer(0x40000000000L, "ProducerConsumer"),
        Identification(0x20000000000L, "Identification"),
        TeachingLearningConfiguration(0x10000000000L, "TeachingLearningConfiguration"),
        RemoteButton(0x8000000000L, "RemoteButton"),
        AbbreviatedDefaultCDI(0x4000000000L, "AbbreviatedDefaultCDI"),
        Display(0x2000000000L, "Display"),
        SimpleNodeID(0x1000000000L, "SNII"),
        ConfigurationDescription(0x800000000L, "CDI"),
        TractionControl(0x400000000L, "TractionControl"),
        FunctionDescription(0x200000000L, "FDI"),
        DccCommandStation(0x100000000L, "DccCommandStation"),
        SimpleTrainNodeInfo(0x80000000L, "SimpleTrainNodeInfo"),
        FunctionConfiguration(0x40000000L, "FunctionConfiguration"),
        FirmwareUpgrade(0x20000000L, "FirmwareUpgrade"),
        FirmwareUpgradeActive(0x10000000L, "FirmwareUpgradeActive");

        long value;
        String name;

        private Protocol(long value, String name) {
            this.value = value;
            this.name = name;
        }

        boolean supports(long r) {
            return (this.value & r) != 0L;
        }

        public String getName() {
            return this.name;
        }

        static List<String> decodeNames(long r) {
            ArrayList<String> retval = new ArrayList<String>();
            for (Protocol t : Protocol.values()) {
                if (!t.supports(r)) continue;
                retval.add(t.name);
            }
            return retval;
        }

        static List<Protocol> decode(long r) {
            ArrayList<Protocol> retval = new ArrayList<Protocol>();
            for (Protocol t : Protocol.values()) {
                if (!t.supports(r)) continue;
                retval.add(t);
            }
            return retval;
        }
    }
}

