/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.EventState;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class ProducerIdentifiedMessage
extends EventMessage {
    private final EventState eventState;

    public ProducerIdentifiedMessage(NodeID source, EventID eventID, EventState eventState) {
        super(source, eventID);
        this.eventState = eventState;
    }

    public EventState getEventState() {
        return this.eventState;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleProducerIdentified(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ProducerIdentifiedMessage p = (ProducerIdentifiedMessage)o;
        return this.eventState == p.eventState;
    }

    @Override
    public String toString() {
        return super.toString() + " Producer Identified " + this.eventState.toString() + " for " + this.eventID.toString();
    }

    @Override
    public int getMTI() {
        return 12963;
    }
}

