/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class OptionalIntRejectedMessage
extends AddressedPayloadMessage {
    int mti;
    int code;

    public OptionalIntRejectedMessage(NodeID source, NodeID dest, int mti, int code) {
        super(source, dest, OptionalIntRejectedMessage.toPayload(mti, code));
        this.mti = mti;
        this.code = code;
    }

    @Deprecated
    @SuppressFBWarnings(value={"NM_VERY_CONFUSING"}, justification="Very confusing to have methods getMti() and getMTI()")
    public int getMti() {
        return this.mti;
    }

    public int getRejectMTI() {
        return this.mti;
    }

    public int getCode() {
        return this.code;
    }

    private static byte[] toPayload(int mti, int code) {
        byte[] b = new byte[4];
        Utilities.HostToNetworkUint16(b, 0, mti);
        Utilities.HostToNetworkUint16(b, 2, code);
        return b;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OptionalIntRejectedMessage) {
            return this.equals((OptionalIntRejectedMessage)o);
        }
        return false;
    }

    public boolean equals(OptionalIntRejectedMessage o) {
        if (o == null || this.mti != o.getRejectMTI() || this.code != o.getCode()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleOptionalIntRejected(this, sender);
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder(super.toString());
        value.append(" Optional Interaction Rejected for MTI 0x");
        value.append(Integer.toHexString(this.getRejectMTI() & 0xFFF).toUpperCase());
        value.append(" code 0x");
        value.append(Integer.toHexString(this.getCode() & 0xFFFF).toUpperCase());
        return new String(value);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.OptionalInteractionRejected;
    }
}

