/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.AbstractConnection;
import org.openlcb.Connection;
import org.openlcb.InitializationCompleteMessage;
import org.openlcb.Interaction;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.OptionalIntRejectedMessage;
import org.openlcb.ProtocolIdentification;
import org.openlcb.ProtocolIdentificationReplyMessage;
import org.openlcb.ProtocolIdentificationRequestMessage;
import org.openlcb.SimpleNodeIdent;
import org.openlcb.SimpleNodeIdentInfoReplyMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;
import org.openlcb.VerifyNodeIDNumberMessage;

public class MimicNodeStore
extends AbstractConnection {
    public static final String ADD_PROP_NODE = "AddNode";
    public static final String CLEAR_ALL_NODES = "ClearAllNodes";
    private static final Logger logger = Logger.getLogger(MimicNodeStore.class.getName());
    Connection connection;
    NodeID node;
    private static MimicNodeStoreTimer timer = new MimicNodeStoreTimer();
    HashMap<NodeID, NodeMemo> map = new HashMap();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public MimicNodeStore(Connection connection, NodeID node) {
        this.connection = connection;
        this.node = node;
        MimicNodeStore.timer.init();
    }

    public void dispose() {
        MimicNodeStore.timer.cancel();
    }

    void scheduleTask(TimerTask t, int delay) {
        MimicNodeStore.timer.schedule(t, delay);
    }

    public Collection<NodeMemo> getNodeMemos() {
        return this.map.values();
    }

    @Override
    public void put(Message msg, Connection sender) {
        NodeMemo memo = this.addNode(msg.getSourceNodeID());
        memo.put(msg, sender);
    }

    public void refresh() {
        this.map.clear();
        this.pcs.firePropertyChange(CLEAR_ALL_NODES, null, null);
        this.connection.put(new VerifyNodeIDNumberMessage(this.node), this);
    }

    public NodeMemo addNode(NodeID id) {
        NodeMemo memo = this.map.get(id);
        if (memo == null) {
            memo = new NodeMemo(id);
            this.map.put(id, memo);
            this.pcs.firePropertyChange(ADD_PROP_NODE, null, memo);
        }
        return memo;
    }

    public NodeMemo findNode(NodeID id) {
        NodeMemo memo = this.map.get(id);
        if (memo != null) {
            return memo;
        }
        this.connection.put(new VerifyNodeIDNumberMessage(this.node, id), null);
        return null;
    }

    public SimpleNodeIdent getSimpleNodeIdent(NodeID dest) {
        NodeMemo memo = this.map.get(dest);
        return memo == null ? null : memo.getSimpleNodeIdent();
    }

    public ProtocolIdentification getProtocolIdentification(NodeID dest) {
        NodeMemo memo = this.map.get(dest);
        return memo == null ? null : memo.getProtocolIdentification();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public class NodeMemo
    extends MessageDecoder {
        public static final String UPDATE_PROP_SIMPLE_NODE_IDENT = "updateSimpleNodeIdent";
        public static final String UPDATE_PROP_PROTOCOL = "updateProtocol";
        NodeID id;
        Queue<Interaction> pendingInteractions = new ConcurrentLinkedDeque<Interaction>();
        Interaction currentInteraction = null;
        private TimerTask currentTask;
        ProtocolIdentification pIdent = null;
        Interaction pipInteraction = null;
        SimpleNodeIdent pSimpleNode = null;
        Interaction snipInteraction = null;
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public NodeMemo(NodeID id) {
            this.id = id;
        }

        public NodeID getNodeID() {
            return this.id;
        }

        public synchronized void startInteraction(Interaction request) {
            if (this.currentInteraction == null) {
                this.doStart(request);
            } else {
                this.pendingInteractions.add(request);
            }
        }

        private synchronized void doStart(final Interaction request) {
            if (request == null) {
                return;
            }
            this.currentInteraction = request;
            request.sendRequest(MimicNodeStore.this.connection);
            this.currentTask = new TimerTask(){

                @Override
                public void run() {
                    request.onTimeout();
                    NodeMemo.this.tryCompleteInteraction(request);
                }
            };
            MimicNodeStore.this.scheduleTask(this.currentTask, request.deadlineMsec);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void tryCompleteInteraction(@Nullable Interaction request) {
            if (request == null) {
                return;
            }
            Interaction interaction = request;
            synchronized (interaction) {
                request.isComplete = true;
            }
            if (this.currentInteraction != request) {
                return;
            }
            this.completeInteraction(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void completeInteraction(Interaction request) {
            if (request != this.currentInteraction) {
                throw new RuntimeException("Trying to complete an interaction that is not started.");
            }
            Interaction interaction = request;
            synchronized (interaction) {
                request.isComplete = true;
            }
            this.currentTask.cancel();
            this.currentInteraction = null;
            this.currentTask = null;
            if (this.pendingInteractions.isEmpty()) {
                return;
            }
            this.currentInteraction = this.pendingInteractions.remove();
            this.doStart(this.currentInteraction);
        }

        @Override
        public void handleProtocolIdentificationReply(ProtocolIdentificationReplyMessage msg, Connection sender) {
            this.pIdent = new ProtocolIdentification(MimicNodeStore.this.node, msg);
            this.pcs.firePropertyChange(UPDATE_PROP_PROTOCOL, null, this.pIdent);
            this.tryCompleteInteraction(this.pipInteraction);
            this.pipInteraction = null;
        }

        public ProtocolIdentification getProtocolIdentification() {
            if (this.pIdent == null) {
                if (this.id == null) {
                    throw new AssertionError((Object)"MimicNodeStore id == null");
                }
                this.pIdent = new ProtocolIdentification(MimicNodeStore.this.node, this.id);
                this.pipInteraction = new Interaction(){
                    int numTriesLeft = 3;

                    @Override
                    void sendRequest(Connection downstream) {
                        NodeMemo.this.pIdent.start(downstream);
                    }

                    @Override
                    NodeID dstNode() {
                        return MimicNodeStore.this.node;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void onTimeout() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.isComplete) {
                                return;
                            }
                        }
                        final 2 request = this;
                        if (--this.numTriesLeft > 0) {
                            MimicNodeStore.this.scheduleTask(new TimerTask(){

                                @Override
                                public void run() {
                                    NodeMemo.this.startInteraction(request);
                                }
                            }, 200);
                        }
                    }
                };
                this.startInteraction(this.pipInteraction);
            }
            return this.pIdent;
        }

        @Override
        public void handleSimpleNodeIdentInfoReply(SimpleNodeIdentInfoReplyMessage msg, Connection sender) {
            if (this.pSimpleNode == null) {
                this.pSimpleNode = new SimpleNodeIdent(msg);
            } else {
                this.pSimpleNode.addMsg(msg);
            }
            if (this.pSimpleNode.contentComplete()) {
                this.tryCompleteInteraction(this.snipInteraction);
                this.snipInteraction = null;
            }
            this.pcs.firePropertyChange(UPDATE_PROP_SIMPLE_NODE_IDENT, null, this.pSimpleNode);
        }

        public SimpleNodeIdent getSimpleNodeIdent() {
            if (this.pSimpleNode == null) {
                this.pSimpleNode = new SimpleNodeIdent(MimicNodeStore.this.node, this.id);
                this.snipInteraction = new Interaction(){
                    int numTriesLeft = 3;

                    @Override
                    void sendRequest(Connection downstream) {
                        NodeMemo.this.pSimpleNode.start(downstream);
                    }

                    @Override
                    NodeID dstNode() {
                        return MimicNodeStore.this.node;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    void onTimeout() {
                        3 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.isComplete) {
                                return;
                            }
                        }
                        final 3 request = this;
                        if (--this.numTriesLeft > 0) {
                            MimicNodeStore.this.scheduleTask(new TimerTask(){

                                @Override
                                public void run() {
                                    NodeMemo.this.startInteraction(request);
                                }
                            }, 200);
                        }
                    }
                };
                this.startInteraction(this.snipInteraction);
            }
            return this.pSimpleNode;
        }

        @Override
        public void handleOptionalIntRejected(OptionalIntRejectedMessage msg, Connection sender) {
            if (msg.getRejectMTI() == MessageTypeIdentifier.SimpleNodeIdentInfoRequest.mti()) {
                if ((msg.getCode() & 0x1000) == 0) {
                    String logmsg = "Permanent error geting Simple Node Info for node {0} code 0x{1}";
                    Object[] logparam = new Object[]{msg.getSourceNodeID(), Integer.toHexString(msg.getCode()).toUpperCase()};
                    logger.log(Level.SEVERE, logmsg, logparam);
                    return;
                }
                MimicNodeStore.this.connection.put(new SimpleNodeIdentInfoRequestMessage(MimicNodeStore.this.node, msg.getSourceNodeID()), null);
            }
            if (msg.getRejectMTI() == MessageTypeIdentifier.ProtocolSupportInquiry.mti()) {
                if ((msg.getCode() & 0x1000) == 0) {
                    String logmsg = "Permanent error geting Protocol Identification information for node {0} code 0x{1}";
                    Object[] logparam = new Object[]{msg.getSourceNodeID(), Integer.toHexString(msg.getCode()).toUpperCase()};
                    logger.log(Level.SEVERE, logmsg, logparam);
                    return;
                }
                MimicNodeStore.this.connection.put(new ProtocolIdentificationRequestMessage(MimicNodeStore.this.node, msg.getSourceNodeID()), null);
            }
        }

        @Override
        public void handleInitializationComplete(InitializationCompleteMessage msg, Connection sender) {
            if (!msg.getSourceNodeID().equals(this.id)) {
                return;
            }
            int timeoutMsec = (int)(100.0 + Math.random() * 200.0);
            Interaction fakeInteraction = new Interaction(){

                @Override
                void sendRequest(Connection downstream) {
                }

                @Override
                NodeID dstNode() {
                    return MimicNodeStore.this.node;
                }

                @Override
                void onTimeout() {
                }
            };
            fakeInteraction.deadlineMsec = timeoutMsec;
            this.startInteraction(fakeInteraction);
            if (this.pSimpleNode != null) {
                this.pSimpleNode = null;
                this.getSimpleNodeIdent();
            }
            if (this.pIdent != null) {
                this.pIdent = null;
                this.getProtocolIdentification();
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private static class MimicNodeStoreTimer {
        private Timer timer;

        private MimicNodeStoreTimer() {
        }

        private synchronized void init() {
            if (this.timer == null) {
                this.timer = new Timer("OpenLCB Mimic Node Store Timer");
            }
        }

        private synchronized void schedule(TimerTask t, int delay) {
            if (this.timer != null) {
                this.timer.schedule(t, delay);
            }
        }

        private synchronized void cancel() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }
}

