/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import java.util.HashMap;
import java.util.Map;

public enum MessageTypeIdentifier {
    InitializationComplete(false, false, false, 0, 0, 8, 0, "InitializationComplete"),
    VerifyNodeIdAddressed(true, false, false, 0, 1, 4, 0, "VerifyNodeIdAddressed"),
    VerifyNodeIdGlobal(false, false, true, 0, 1, 4, 0, "VerifyNodeIdGlobal"),
    VerifiedNodeId(false, false, true, 0, 0, 11, 0, "VerifiedNodeId"),
    OptionalInteractionRejected(true, false, false, 0, 0, 3, 0, "OptionalInteractionRejected"),
    TerminateDueToError(true, false, false, 0, 0, 5, 0, "TerminateDueToError"),
    ProtocolSupportInquiry(true, false, false, 0, 2, 1, 0, "ProtocolSupportInquiry"),
    ProtocolSupportReply(true, false, false, 0, 1, 19, 0, "ProtocolSupportReply"),
    IdentifyConsumer(false, true, true, 0, 2, 7, 0, "IdentifyConsumer"),
    ConsumerRangeIdentified(false, true, false, 0, 1, 5, 0, "ConsumerRangeIdentified"),
    ConsumerIdentifiedUnknown(false, true, false, 0, 1, 6, 3, "ConsumerIdentifiedUnknown"),
    ConsumerIdentifiedValid(false, true, false, 0, 1, 6, 0, "ConsumerIdentifiedValid"),
    ConsumerIdentifiedInvalid(false, true, false, 0, 1, 6, 1, "ConsumerIdentifiedInvalid"),
    IdentifyProducer(false, true, true, 0, 2, 8, 0, "IdentifyProducer"),
    ProducerRangeIdentified(false, true, false, 0, 1, 9, 0, "ProducerRangeIdentified"),
    ProducerIdentifiedUnknown(false, true, false, 0, 1, 10, 3, "ProducerIdentifiedUnknown"),
    ProducerIdentifiedValid(false, true, false, 0, 1, 10, 0, "ProducerIdentifiedValid"),
    ProducerIdentifiedInvalid(false, true, false, 0, 1, 10, 1, "ProducerIdentifiedInvalid"),
    IdentifyEventsAddressed(true, false, false, 0, 2, 11, 0, "IdentifyEventsAddressed"),
    IdentifyEventsGlobal(false, false, true, 0, 2, 11, 0, "IdentifyEventsGlobal"),
    LearnEvent(false, true, true, 0, 1, 12, 0, "LearnEvent"),
    ProducerConsumerEventReport(false, true, true, 0, 1, 13, 0, "ProducerConsumerEventReport"),
    TractionControlRequest(true, false, false, 0, 1, 15, 3, "TractionControlRequest"),
    TractionControlReply(true, false, false, 0, 0, 15, 1, "TractionControlReply"),
    TractionProxyRequest(true, false, false, 0, 1, 15, 2, "TractionProxyRequest"),
    TractionProxyReply(true, false, false, 0, 0, 15, 0, "TractionProxyReply"),
    SimpleNodeIdentInfoRequest(true, false, false, 0, 3, 15, 0, "SimpleNodeIdentInfoRequest"),
    SimpleNodeIdentInfoReply(true, false, false, 0, 2, 16, 0, "SimpleNodeIdentInfoReply"),
    Datagram(true, false, false, 1, 3, 2, 0, "Datagram"),
    DatagramReceivedOK(true, false, false, 0, 2, 17, 0, "DatagramReceivedOK"),
    DatagramRejected(true, false, false, 0, 2, 18, 0, "DatagramRejected"),
    StreamInitiateRequest(true, false, false, 0, 3, 6, 0, "StreamInitiateRequest"),
    StreamInitiateReply(true, false, false, 0, 2, 3, 0, "StreamInitiateReply"),
    StreamDataSend(true, false, false, 1, 3, 28, 0, "StreamDataSend"),
    StreamDataProceed(true, false, false, 0, 2, 4, 0, "StreamDataProceed"),
    StreamDataComplete(true, false, false, 0, 2, 5, 0, "StreamDataComplete");

    private static Map<Integer, MessageTypeIdentifier> mapping;
    boolean addressed;
    boolean hasEventID;
    int modifier;
    boolean isSimpleModeMessage;
    int priorityGroup;
    int typeNumber;
    int upper;
    String name;

    private static Map<Integer, MessageTypeIdentifier> getMap() {
        if (mapping == null) {
            mapping = new HashMap<Integer, MessageTypeIdentifier>();
        }
        return mapping;
    }

    private MessageTypeIdentifier(boolean addressed, boolean hasEventID, boolean isSimpleModeMessage, int upper, int priorityGroup, int typeNumber, int modifier, String name) {
        this.addressed = addressed;
        this.hasEventID = hasEventID;
        this.modifier = modifier;
        this.isSimpleModeMessage = isSimpleModeMessage;
        this.priorityGroup = priorityGroup;
        this.typeNumber = typeNumber;
        this.upper = upper;
        this.name = name;
        MessageTypeIdentifier.getMap().put(this.mti(), this);
    }

    public String toString() {
        return this.name;
    }

    public int mti() {
        int retval = 0;
        retval |= this.upper << 12;
        retval |= this.priorityGroup << 10;
        retval |= this.typeNumber << 5;
        retval |= this.modifier & 3;
        if (this.addressed) {
            retval |= 8;
        }
        if (this.hasEventID) {
            retval |= 4;
        }
        if (this.isSimpleModeMessage) {
            retval |= 0x10;
        }
        return retval;
    }

    public static MessageTypeIdentifier get(int mti) {
        return mapping.get(mti);
    }
}

