/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import org.openlcb.AbstractConnection;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;

public class Gateway
extends MessageDecoder {
    protected Connection eastOutputConnection;
    protected Connection eastInputConnection;
    protected Connection westOutputConnection;
    protected Connection westInputConnection;

    public Connection getEastConnection() {
        this.eastInputConnection = new AbstractConnection(){

            @Override
            public void put(Message msg, Connection sender) {
                Gateway.this.sendMessageToWest(msg, sender);
            }
        };
        return this.eastInputConnection;
    }

    protected void sendMessageToWest(Message msg, Connection sender) {
        if (this.westOutputConnection == null) {
            throw new AssertionError((Object)"west was null when message sent");
        }
        this.westOutputConnection.put(msg, this.westInputConnection);
    }

    public void registerEast(Connection c) {
        if (this.eastOutputConnection != null) {
            throw new AssertionError((Object)"east already registered");
        }
        this.eastOutputConnection = c;
    }

    public Connection getWestConnection() {
        this.westInputConnection = new AbstractConnection(){

            @Override
            public void put(Message msg, Connection sender) {
                Gateway.this.sendMessageToEast(msg, sender);
            }
        };
        return this.westInputConnection;
    }

    protected void sendMessageToEast(Message msg, Connection sender) {
        if (this.eastOutputConnection == null) {
            throw new AssertionError((Object)"east was null when message sent");
        }
        this.eastOutputConnection.put(msg, this.eastInputConnection);
    }

    public void registerWest(Connection c) {
        if (this.westOutputConnection != null) {
            throw new AssertionError((Object)"west already registered");
        }
        this.westOutputConnection = c;
    }
}

