/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class EventID {
    static final int BYTECOUNT = 8;
    byte[] contents;

    @CheckReturnValue
    public EventID(@NonNull NodeID node, int b7, int b8) {
        this.contents = new byte[8];
        System.arraycopy(node.contents, 0, this.contents, 0, 6);
        this.contents[6] = (byte)b7;
        this.contents[7] = (byte)b8;
    }

    @CheckReturnValue
    public EventID(@NonNull byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        if (contents.length != 8) {
            throw new IllegalArgumentException("Wrong EventID length: " + contents.length);
        }
        this.contents = new byte[8];
        System.arraycopy(contents, 0, this.contents, 0, 8);
    }

    @CheckReturnValue
    public EventID(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        byte[] data = Utilities.bytesFromHexString(value);
        if (data.length != 8) {
            throw new IllegalArgumentException("Wrong EventID length: " + data.length);
        }
        this.contents = new byte[8];
        System.arraycopy(data, 0, this.contents, 0, 8);
    }

    @CheckReturnValue
    @NonNull
    public byte[] getContents() {
        byte[] retval = new byte[8];
        System.arraycopy(this.contents, 0, retval, 0, 8);
        return retval;
    }

    @CheckReturnValue
    public boolean equals(Object o) {
        try {
            EventID other = (EventID)o;
            for (int i = 0; i < 8; ++i) {
                if (other.contents[i] == this.contents[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean startsWith(NodeID id) {
        for (int i = 0; i < 6; ++i) {
            if (this.contents[i] == id.contents[i]) continue;
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public int hashCode() {
        return (this.contents[0] << 21) + (this.contents[1] << 18) + (this.contents[2] << 15) + (this.contents[3] << 12) + (this.contents[4] << 9) + (this.contents[5] << 6) + (this.contents[6] << 3) + this.contents[7];
    }

    @CheckReturnValue
    @NonNull
    public String toString() {
        return "EventID:" + Utilities.toHexPair(this.contents[0]) + "." + Utilities.toHexPair(this.contents[1]) + "." + Utilities.toHexPair(this.contents[2]) + "." + Utilities.toHexPair(this.contents[3]) + "." + Utilities.toHexPair(this.contents[4]) + "." + Utilities.toHexPair(this.contents[5]) + "." + Utilities.toHexPair(this.contents[6]) + "." + Utilities.toHexPair(this.contents[7]);
    }

    public long toLong() {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret <<= 8;
            byte e = this.contents[i];
            ret |= (long)(e & 0xFF);
        }
        return ret;
    }
}

