/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class DatagramRejectedMessage
extends AddressedPayloadMessage {
    int code;
    static final int DATAGRAM_REJECTED = 0;
    static final int DATAGRAM_REJECTED_PERMANENT_ERROR = 256;
    static final int DATAGRAM_REJECTED_INFORMATION_LOGGED = 257;
    static final int DATAGRAM_REJECTED_SOURCE_NOT_PERMITTED = 258;
    static final int DATAGRAM_REJECTED_DATAGRAMS_NOT_ACCEPTED = 260;
    static final int DATAGRAM_REJECTED_BUFFER_FULL = 512;
    static final int DATAGRAM_REJECTED_OUT_OF_ORDER = 1536;
    static final int DATAGRAM_REJECTED_NO_RESEND_MASK = 256;
    static final int DATAGRAM_REJECTED_RESEND_MASK = 512;
    static final int DATAGRAM_REJECTED_TRANSPORT_ERROR_MASK = 1024;
    public static final int DATAGRAM_REJECTED_DST_REBOOT = 65792;

    public DatagramRejectedMessage(NodeID source, NodeID dest, int code) {
        super(source, dest, DatagramRejectedMessage.toPayload(code));
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    private static byte[] toPayload(int code) {
        byte[] b = new byte[2];
        Utilities.HostToNetworkUint16(b, 0, code);
        return b;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleDatagramRejected(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DatagramRejectedMessage)) {
            return false;
        }
        if (this.code != ((DatagramRejectedMessage)o).getCode()) {
            return false;
        }
        return super.equals(o);
    }

    public boolean canResend() {
        return (this.code & 0x200) == 512;
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.DatagramRejected;
    }
}

