/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class DatagramMessage
extends AddressedMessage {
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    protected int[] data;

    public DatagramMessage(NodeID source, NodeID dest, int[] dataIn) {
        super(source, dest);
        this.data = new int[dataIn.length];
        System.arraycopy(dataIn, 0, this.data, 0, dataIn.length);
    }

    public DatagramMessage(NodeID source, NodeID dest, byte[] dataIn) {
        super(source, dest);
        this.data = new int[dataIn.length];
        for (int i = 0; i < dataIn.length; ++i) {
            this.data[i] = dataIn[i] & 0xFF;
        }
    }

    protected DatagramMessage(NodeID source, NodeID dest) {
        super(source, dest);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DatagramMessage)) {
            return false;
        }
        DatagramMessage msg = (DatagramMessage)o;
        if (this.getData().length != msg.getData().length) {
            return false;
        }
        int n = this.getData().length;
        int[] d1 = this.getData();
        int[] d2 = msg.getData();
        for (int i = 0; i < n; ++i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.getSourceNodeID().hashCode() + this.getDestNodeID().hashCode();
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleDatagram(this, sender);
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public int getMTI() {
        return 5124;
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder(super.toString());
        value.append(" Datagram: ");
        int n = this.getData().length;
        value.append("(" + n + ") ");
        boolean first = true;
        for (int i = 0; i < n; ++i) {
            if (!first) {
                value.append(".");
            }
            value.append(Integer.toHexString(this.data[i] & 0xFF).toUpperCase());
            first = false;
        }
        return new String(value);
    }
}

