/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.EventState;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class ConsumerIdentifiedMessage
extends EventMessage {
    private final EventState eventState;

    public ConsumerIdentifiedMessage(NodeID source, EventID eventID, EventState eventState) {
        super(source, eventID);
        this.eventState = eventState;
    }

    @Override
    public EventID getEventID() {
        return this.eventID;
    }

    public EventState getEventState() {
        return this.eventState;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleConsumerIdentified(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ConsumerIdentifiedMessage p = (ConsumerIdentifiedMessage)o;
        return this.eventState == p.eventState;
    }

    @Override
    public String toString() {
        return super.toString() + " Consumer Identified " + this.eventState.toString() + " for " + this.eventID.toString();
    }

    @Override
    public int getMTI() {
        return 12899;
    }
}

